% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeViz-methods.R
\name{show,TreeViz-method}
\alias{show,TreeViz-method}
\alias{aggregateTree}
\alias{aggregateTree,TreeViz-method}
\alias{register,TreeViz-method}
\alias{plot,TreeViz,ANY-method}
\title{show object}
\usage{
\S4method{show}{TreeViz}(object)

aggregateTree(x, ...)

\S4method{aggregateTree}{TreeViz}(
  x,
  selectedLevel = 3,
  selectedNodes = NULL,
  aggFun = colSums,
  start = 1,
  end = NULL,
  by = "row",
  format = "TreeViz"
)

\S4method{register}{TreeViz}(object, tree = "row", columns = NULL, ...)

\S4method{plot}{TreeViz,ANY}(x, y)
}
\arguments{
\item{object}{The object to register to data server}

\item{x}{treeviz object}

\item{...}{Additional arguments passed to object constructors}

\item{selectedLevel}{level to select nodes from}

\item{selectedNodes}{used to set states on individual nodes to define a cut on the tree}

\item{aggFun}{aggregate function to use, by default colSums if by="row", rowSums if by="col"}

\item{start, end}{indices to filter nodes}

\item{by}{"row" to aggregate the TreeIndex on rowData, "col" to aggregate TreeIndex on colData}

\item{format}{return format can be one of "counts" or "TreeViz"}

\item{tree}{Is tree over rows or columns of the object (default: "row")}

\item{columns}{Name of columns containing data to register}

\item{y}{none}
}
\value{
describe a TreeIndex object

a generic

a Treeviz object or type specified by format

An \code{\link{EpivizTreeData-class}} object

Dataframe containing cluster information at different resolutions
}
\description{
show object

Method to aggregate a TreeViz object

Method to aggregate a TreeViz object

Generic method to register data to the epiviz data server

plot tree from TreeViz
}
\section{Functions}{
\itemize{
\item \code{show,TreeViz-method}: 

\item \code{aggregateTree}: 

\item \code{aggregateTree,TreeViz-method}: 

\item \code{register,TreeViz-method}: 

\item \code{plot,TreeViz,ANY-method}: 
}}

\examples{
\donttest{ 
library(metagenomeSeq)
data(mouseData)
counts <- MRcounts(mouseData)
hierarchy <- fData(mouseData)
tree <- TreeIndex(hierarchy)
mbiome <- TreeViz(SimpleList(counts=counts), rowData=tree)
aggregateTree(mbiome)
}
\donttest{ 
library(metagenomeSeq)
data(mouseData)
counts <- MRcounts(mouseData)
hierarchy <- fData(mouseData)
tree <- TreeIndex(hierarchy)
mbiome <- TreeViz(SimpleList(counts=counts), rowData=tree)
aggregateTree(mbiome)
}
\donttest{
library(metagenomeSeq)
data(mouseData)
counts <- MRcounts(mouseData)
hierarchy <- fData(mouseData)
tree <- TreeIndex(hierarchy)
mbiome <- TreeViz(SimpleList(counts=counts), rowData=tree)
plot(mbiome)
}
}
