\name{cellCellReport}
\docType{methods}
\alias{cellCellReport,SingleCellExperiment-method}
\alias{cellCellReport}

\title{
HTML report of the result of scTensor
}
\description{
The result is saved as HTML report which contains with multiple files.
}
\usage{
cellCellReport(sce, reducedDimNames,
    out.dir=tempdir(), html.open=FALSE,
    title="The result of scTensor",
    author="The person who runs this script", assayNames = "counts", thr=100,
    top="full", p=0.05, upper=20,
    goenrich=TRUE, meshenrich=TRUE, reactomeenrich=TRUE,
    doenrich=TRUE, ncgenrich=TRUE, dgnenrich=TRUE, nbins=40)
}

\arguments{
\item{sce}{
A object generated by instantization of SingleCellExperiment-class.
}
\item{reducedDimNames}{
The name of two-dimentional data saved in reducedDimNames slot of
SingleCellExperiment object.
}
\item{out.dir}{
The output directory for saving HTML report (out.dir: tempdir()).
}
\item{html.open}{
Whether the result of HTML report is opened when the calculation is finished
(Default: FALSE).
}
\item{title}{
The title of HTML report (Default: "The result of scTensor").
}
\item{author}{
The author of HTML report (Default: "The person who runs this script").
}
\item{assayNames}{
The unit of gene expression for using scTensor (e.g. normcounts, cpm...etc) (Default: "counts").
}
\item{thr}{
The threshold for selection of top pecentage of core tensor elements
(Default: 100 (1 to 100)).
}
\item{top}{
top genes in each (*,*,*)-pattern which are selected and summarized in the report (Default: "full")
}
\item{p}{
The threshold of p-value of the enrichment analysis (Default: 1E-2)
}
\item{upper}{
The maxium number of HTML reports generates (Default: 20)
}
\item{goenrich}{
Whether GO-Enrichment analysis is performed (Default: TRUE)
}
\item{meshenrich}{
Whether MeSH-Enrichment analysis is performed (Default: TRUE)
}
\item{reactomeenrich}{
Whether Reactome-Enrichment analysis is performed (Default: TRUE)
}
\item{doenrich}{
Whether DO-Enrichment analysis is performed (Default: TRUE)
}
\item{ncgenrich}{
Whether NCG-Enrichment analysis is performed (Default: TRUE)
}
\item{dgnenrich}{
Whether DGN-Enrichment analysis is performed (Default: TRUE)
}
\item{nbins}{
The number of bins used for the two dimensional plot of schex (Default: 40)
}
}

\value{
The result is saved as HTML report which contains with multiple files.
}
\seealso{
\code{\link[SingleCellExperiment]{SingleCellExperiment}}.
}

\author{Koki Tsuyuzaki}

\examples{
	if(interactive()){
	# Package Loading
	library("SingleCellExperiment")
	library("AnnotationHub")
	if(!require(LRBaseDbi)){
	    BiocManager::install("LRBaseDbi")
	    library(LRBaseDbi)
	}
	ah <- AnnotationHub()
	dbfile <- query(ah, c("LRBaseDb", "Homo sapiens"))[[1]]
	LRBase.Hsa.eg.db <- LRBaseDbi::LRBaseDb(dbfile)

	# Data Loading
	data(GermMale)
	data(labelGermMale)
	data(tsneGermMale)

	# SingleCellExperiment Object
	sce <- SingleCellExperiment(assays=list(counts = GermMale))
	reducedDims(sce) <- SimpleList(TSNE=tsneGermMale$Y)

	# User's Original Normalization Function
	CPMED <- function(input){
	    libsize <- colSums(input)
	    median(libsize) * t(t(input) / libsize)
	}
	# Normalization
	normcounts(sce) <- log10(CPMED(counts(sce)) + 1)

	# Registration of required information into metadata(sce)
	cellCellSetting(sce, LRBase.Hsa.eg.db, names(labelGermMale))

	# Rank Estimation
	rks <- cellCellRanks(sce, assayNames="normcounts")

	# CCI Tensor Decomposition
	set.seed(1234)
	cellCellDecomp(sce, ranks=rks$selected, assayNames="normcounts")

	# HTML Report
	options(device.ask.default = FALSE)
	cellCellReport(sce, reducedDimNames="TSNE",
        out.dir=tempdir(), html.open=FALSE,
        title="The result of scTensor",
        author="The person who runs this script",
        assayNames="counts", thr=100,
        top="full", p=0.05, upper=20,
        goenrich=TRUE, meshenrich=TRUE, reactomeenrich=TRUE,
        doenrich=TRUE, ncgenrich=TRUE, dgnenrich=TRUE, nbins=40)
    }else{
        showMethods("cellCellReport")
    }
}

\keyword{methods}