% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_model.R
\name{select_model}
\alias{select_model}
\title{select_model}
\usage{
select_model(lrt.value)
}
\arguments{
\item{lrt.value}{A list of genes with the p-values from performing the GOF tests
from \code{gof_model}}
}
\value{
A list of selected model distributions for genes scShapes selects.
}
\description{
This function is used to select the distribution of best fit for scRNA-seq count data
}
\examples{

data(scData)

# apply the select_model function to the best fit model from the results of
# the gof_model function

library(BiocParallel)
scData_models <- fit_models(counts=scData$counts, cexpr=scData$covariates,
                            lib.size=scData$lib_size, BPPARAM=bpparam())
scData_bicvals <- model_bic(scData_models)
scData_least.bic <- lbic_model(scData_bicvals, scData$counts)
scData_gof <- gof_model(scData_least.bic, cexpr=scData$covariates, lib.size=scData$lib_size,
BPPARAM=bpparam())

scData_fit <- select_model(scData_gof)
}
