% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_bic.R
\name{model_bic}
\alias{model_bic}
\title{model_bic}
\usage{
model_bic(fit_list)
}
\arguments{
\item{fit_list}{A list of models fitted from \code{fit_models}}
}
\value{
A dataframe containing the BIC values for each distribution type (P, NB, ZIP, ZINB).
}
\description{
This function is used to calculate the Bayesian information criterion of the models fitted in
\code{fit_models}.
}
\examples{

data(scData)

# apply the model_bic function to calculate the BIC values on the models
# obtained after running fit_models function.

library(BiocParallel)
scData_models <- fit_models(counts=scData$counts, cexpr=scData$covariates, lib.size=scData$lib_size,
BPPARAM=bpparam())

scData_bicvals <- model_bic(scData_models)
}
