% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentAA.R
\name{percentAA}
\alias{percentAA}
\title{Plot Relative Amino Acid Composition by Position}
\usage{
percentAA(
  input.data,
  chain = "TRB",
  group.by = NULL,
  order.by = NULL,
  aa.length = 20,
  exportTable = FALSE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{input.data}{The product of \code{\link[=combineTCR]{combineTCR()}}, \code{\link[=combineBCR]{combineBCR()}}, or
\code{\link[=combineExpression]{combineExpression()}}.}

\item{chain}{The TCR/BCR chain to use. Use \code{both} to include both chains
(e.g., TRA/TRB). Accepted values: \code{TRA}, \code{TRB}, \code{TRG}, \code{TRD}, \code{IGH}, \code{IGL},
\code{IGK}, \code{Light} (for both light chains), or \code{both} (for TRA/B and Heavy/Light).}

\item{group.by}{A column header in the metadata or lists to group the analysis
by (e.g., "sample", "treatment"). If \code{NULL}, data will be analyzed
by list element or active identity in the case of single-cell objects.}

\item{order.by}{A character vector defining the desired order of elements
of the \code{group.by} variable. Alternatively, use \code{alphanumeric} to sort groups
automatically.}

\item{aa.length}{The maximum length of the CDR3 amino acid sequence.}

\item{exportTable}{If \code{TRUE}, returns a data frame or matrix of the results
instead of a plot.}

\item{palette}{Colors to use in visualization - input any \link[grDevices:palettes]{hcl.pals}.}

\item{...}{Additional arguments passed to the ggplot theme}
}
\value{
A ggplot object visualizing amino acid by proportion or a data.frame if
\code{exportTable = TRUE}.
}
\description{
This function the proportion of amino acids along the residues
of the CDR3 amino acid sequence.
}
\examples{
# Making combined contig data
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))

# Using percentAA()
percentAA(combined, 
          chain = "TRB", 
          aa.length = 20)
}
\concept{Summarize_Repertoire}
