% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateInvariant.R
\name{annotateInvariant}
\alias{annotateInvariant}
\title{Annotate invariant T cells (MAIT or iNKT) in single-cell TCR data}
\usage{
annotateInvariant(
  input.data,
  type = c("MAIT", "iNKT"),
  species = c("mouse", "human")
)
}
\arguments{
\item{input.data}{The product of \code{\link[=combineTCR]{combineTCR()}} or \code{\link[=combineExpression]{combineExpression()}}.}

\item{type}{Character specifying the type of invariant cells to
annotate (\code{MAIT} or \code{iNKT}).}

\item{species}{Character specifying the species
('mouse' or 'human').}
}
\value{
A single-cell object or list with the corresponding annotation
scores (0 or 1) added.
}
\description{
The \code{\link[=annotateInvariant]{annotateInvariant()}} function identifies potential mucosal-associated
invariant T (\verb{MAIT``) cells or invariant natural killer T (}iNKT`) cells from
single-cell sequencing datasets based on their characteristic  TCR usage.
It extracts TCR chain information from the provided single-cell
data, checks it against known invariant T-cell receptor criteria for either
MAIT or iNKT cells, and returns a score indicating the presence (1) or
absence (0) of these invariant cell populations for each individual cell.
The function supports data from mouse and human samples, providing a
convenient method to annotate specialized T-cell subsets within single-cell
analyses.
}
\examples{
# Getting the combined contigs
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))

# Getting a sample of a Seurat object
scRep_example <- get(data("scRep_example"))

# Using combineExpresion()
scRep_example <- combineExpression(combined, scRep_example)

# Using annotateInvariant()
annotateInvariant(input.data = scRep_example, type = "MAIT", species = "human")
annotateInvariant(input.data = scRep_example, type = "iNKT", species = "human")

}
