% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countsSampling.R
\name{countsSampling}
\alias{countsSampling}
\title{countsSampling: Downsampling the read counts in a cell}
\usage{
countsSampling(counts, fraction = 0.1)
}
\arguments{
\item{counts}{A cell's raw read counts for each gene, could be a vector or a SingleCellExperiment object.}

\item{fraction}{Fraction of reads to be downsampled, should be between 0-1, default is 0.1.}
}
\value{
A vector of the downsampled read counts of each gene in the cell.
}
\description{
This function is used to downsample the read counts in a cell for single-cell RNA-seq (scRNA-seq) data. It takes a non-negative vector of scRNA-seq raw read counts of a cell as input.
}
\examples{
# Load test data
data(scRecoverTest)

# Downsample the read counts in oneCell
oneCell.down <- countsSampling(counts = oneCell, fraction = 0.1)


}
\seealso{
\code{\link{scRecover}}, for imputation of single-cell RNA-seq data.

\code{\link{estDropoutNum}}, for estimating dropout gene number in a cell.

\code{\link{normalization}}, for normalization of single-cell RNA-seq data.

\code{\link{scRecoverTest}}, a test dataset for scRecover.
}
\author{
Zhun Miao.
}
