% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDataset.R
\name{createAppConfig}
\alias{createAppConfig}
\title{Create a metadata to describe the dataset}
\usage{
createAppConfig(
  title,
  destinationFolder,
  species,
  doi,
  pmid,
  bibentry,
  datatype = c("scRNAseq", "scATACseq", "scMultiome"),
  markers,
  keywords,
  abstract
)
}
\arguments{
\item{title}{The title of the dataset}

\item{destinationFolder}{The destination folder name of the dataset without
the root folder of the datasets. The data will be saved as
\code{appdataFolder/destinationFolder}}

\item{species}{The species of the dataset}

\item{doi, pmid}{The DOI or PMID of the reference}

\item{bibentry}{An object of bibentry}

\item{datatype}{character(1). Type of the data, scRNAseq, scATACseq or
scMultiome.}

\item{markers}{A list of data.frame with gene symbols as rownames or
a character vector.}

\item{keywords}{The keywords for the dataset.
For example the condition, cell type, tissue information
The keywords will be used for whole database search}

\item{abstract}{The abstract of the reference.}
}
\value{
An object of \link{APPconf} object
}
\description{
The function will return a APPconf object which contain
the reference, keywords for the dataset.
}
\examples{
if(interactive()){
    config <- createAppConfig(
        title="pbmc_small",
        destinationFolder = "pbmc_small",
        species = "Homo sapiens",
        doi="10.1038/nbt.3192",
        datatype = "scRNAseq")
}
}
