% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_QTLplot-visualizeQTL.R
\name{draw_QTLplot}
\alias{draw_QTLplot}
\title{Create a combined violin-box-scatter plot.}
\usage{
draw_QTLplot(df, unique_group)
}
\arguments{
\item{df}{A data frame containing gene expression values, SNP genotypes,
and group labels.}

\item{unique_group}{A character string indicating the unique group name.}
}
\value{
ggplot
}
\description{
\code{draw_QTLplot()} creates a composite plot that overlays violin plots,
boxplots, and scatter points to illustrate the distribution and variability
of gene expression across SNP groups.
}
\examples{
set.seed(123)
counts_Ref <- rnorm(50, mean = 10, sd = 2)
counts_Alt <- rnorm(50, mean = 12, sd = 2)
i <- rep("GroupA", 100);unique_group <- unique(i)
dataframe <- data.frame(expression = c(counts_Ref, counts_Alt),
                        snp = c(rep("REF", length(counts_Ref)),
                        rep("ALT", length(counts_Alt))), group = i)
dataframe$snp <- factor(dataframe$snp, levels = c("REF", "ALT"))
draw_QTLplot(df = dataframe, unique_group = unique_group)
}
