% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createQTLObject.R
\name{createQTLObject}
\alias{createQTLObject}
\title{Create an eQTLObject for storing sc-eQTL analysis data.}
\usage{
createQTLObject(
  snpMatrix,
  genedata,
  biClassify = FALSE,
  species = NULL,
  group = NULL,
  ...
)
}
\arguments{
\item{snpMatrix}{A genotype matrix where each row is a snp and each column
is a cell. Encoding should be 0, 1, 2, 3.}

\item{genedata}{A gene expression matrix, or a Seurat object or
SingleCellExperiment object.}

\item{biClassify}{Logical; whether to convert genotype encoding in snpMatrix
to 0, 1, and 2. \code{TRUE} indicates conversion; \code{FALSE} indicates no
conversion (default).}

\item{species}{The species that the user wants to select, human or mouse.}

\item{group}{A column name in the metadata of the Seurat or
SingleCellExperiment object indicating cell groups (e.g., celltype or
condition).}

\item{...}{other parameters}
}
\value{
An S4 object of class \code{eQTLObject}.
}
\description{
This function creates an S4 object to store genotype and expression data,
along with sample grouping and metadata for eQTL analysis.
}
\examples{
data(SNPData)
data(GeneData)
eqtl <- createQTLObject(snpMatrix = SNPData,
                     genedata = GeneData,
                     biClassify = FALSE,
                     species = 'human',
                     group = NULL)

}
