% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_scPipeCPP.R
\name{sc_gene_counting}
\alias{sc_gene_counting}
\title{sc_gene_counting}
\usage{
sc_gene_counting(outdir, bc_anno, UMI_cor = 2, gene_fl = FALSE)
}
\arguments{
\item{outdir}{output folder containing \code{sc_demultiplex} output}

\item{bc_anno}{barcode annotation comma-separated-values, first column is
cell id, second column is cell barcode sequence}

\item{UMI_cor}{correct UMI sequencing error: 0 means no correction, 1 means
simple correction and merge UMI with distance 1. 2 means merge on both UMI
alignment position match.}

\item{gene_fl}{whether to remove low abundance genes. A gene is considered to
have low abundance if only one copy of one UMI is associated with it.}
}
\value{
no return
}
\description{
Generate gene counts matrix with UMI deduplication
}
\examples{
data_dir="celseq2_demo"
barcode_annotation_fn = system.file("extdata", "barcode_anno.csv",
package = "scPipe")
\dontrun{
# refer to the vignettes for the complete workflow
...
sc_gene_counting(data_dir, barcode_annotation_fn)
...
}

}
