% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_scPipeCPP.R
\name{sc_demultiplex_and_count}
\alias{sc_demultiplex_and_count}
\title{sc_demultiplex_and_count}
\usage{
sc_demultiplex_and_count(
  inbam,
  outdir,
  bc_anno,
  max_mis = 1,
  bam_tags = list(am = "YE", ge = "GE", bc = "BC", mb = "OX"),
  mito = "MT",
  has_UMI = TRUE,
  UMI_cor = 1,
  gene_fl = FALSE,
  nthreads = 1
)
}
\arguments{
\item{inbam}{input bam file. This should be the output of
\code{sc_exon_mapping}}

\item{outdir}{output folder}

\item{bc_anno}{barcode annotation, first column is cell id, second column
is cell barcode sequence}

\item{max_mis}{maximum mismatch allowed in barcode. (default: 1)}

\item{bam_tags}{list defining BAM tags where mapping information is
stored.
\itemize{
  \item "am": mapping status tag
  \item "ge": gene id
  \item "bc": cell barcode tag
  \item "mb": molecular barcode tag
}}

\item{mito}{mitochondrial chromosome name.
This should be consistent with the chromosome names in the bam file.}

\item{has_UMI}{whether the protocol contains UMI (default: TRUE)}

\item{UMI_cor}{correct UMI sequencing error: 0 means no correction, 1 means
simple correction and merge UMI with distance 1. 2 means merge on both UMI
alignment position match.}

\item{gene_fl}{whether to remove low abundance genes. A gene is considered to
have low abundance if only one copy of one UMI is associated with it.}

\item{nthreads}{number of threads to use. (default: 1)}
}
\value{
no return
}
\description{
Wrapper to run \code{\link{sc_demultiplex}} and
  \code{\link{sc_gene_counting}} with a single command
}
\examples{
\dontrun{
refer to the vignettes for the complete workflow, replace demultiplex and
count with single command:
...
sc_demultiplex_and_count(
   file.path(data_dir, "out.map.bam"),
   data_dir,
   barcode_annotation_fn,
   has_UMI = FALSE
)
...
}

}
