% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_atac_create_fragments.R
\name{sc_atac_create_fragments}
\alias{sc_atac_create_fragments}
\title{Generating the popular fragments for scATAC-Seq data}
\usage{
sc_atac_create_fragments(
  inbam,
  output_folder = "",
  min_mapq = 30,
  nproc = 1,
  cellbarcode = "CB",
  chromosomes = "^chr",
  readname_barcode = NULL,
  cells = NULL,
  max_distance = 5000,
  min_distance = 10,
  chunksize = 5e+05
)
}
\arguments{
\item{inbam}{The tagged, sorted and duplicate-free input BAM file}

\item{output_folder}{The path of the output folder}

\item{min_mapq}{: int
Minimum MAPQ to retain fragment}

\item{nproc}{: int, optional
Number of processors to use. Default is 1.}

\item{cellbarcode}{: str
Tag used for cell barcode. Default is CB (used by cellranger)}

\item{chromosomes}{: str, optional
Regular expression used to match chromosome names to include in the
output file. Default is "(?i)^chr" (starts with "chr", case-insensitive).
If None, use all chromosomes in the BAM file.}

\item{readname_barcode}{: str, optional
Regular expression used to match cell barocde stored in read name.
If None (default), use read tags instead. Use "[^:]*" to match all characters
before the first colon (":").}

\item{cells}{: str
File containing list of cell barcodes to retain. If None (default), use all cell barcodes
found in the BAM file.}

\item{max_distance}{: int, optional
Maximum distance between integration sites for the fragment to be retained.
Allows filtering of implausible fragments that likely result from incorrect
mapping positions. Default is 5000 bp.}

\item{min_distance}{: int, optional
Minimum distance between integration sites for the fragment to be retained.
Allows filtering implausible fragments that likely result from incorrect
mapping positions. Default is 10 bp.}

\item{chunksize}{: int
Number of BAM entries to read through before collapsing and writing
fragments to disk. Higher chunksize will use more memory but will be
faster.}
}
\value{
returns NULL
}
\description{
Takes in a tagged and sorted BAM file and outputs the associated fragments in a .bed file
}
