% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_atac_cell_calling.R
\name{sc_atac_cell_calling}
\alias{sc_atac_cell_calling}
\title{identifying true vs empty cells}
\usage{
sc_atac_cell_calling(
  mat,
  cell_calling = "filter",
  output_folder,
  genome_size = NULL,
  cell_qc_metrics_file = NULL,
  lower = NULL,
  min_uniq_frags = 3000,
  max_uniq_frags = 50000,
  min_frac_peak = 0.3,
  min_frac_tss = 0,
  min_frac_enhancer = 0,
  min_frac_promoter = 0.1,
  max_frac_mito = 0.15
)
}
\arguments{
\item{mat}{the feature by cell matrix.}

\item{cell_calling}{the cell calling approach, possible options were "emptydrops" , "cellranger" and "filter".
But we opten to using "filter" as it was most robust. "emptydrops" is still an opition for data with large umber of cells.}

\item{output_folder}{output directory for the cell called matrix.}

\item{genome_size}{genome size for the data in feature by cell matrix.}

\item{cell_qc_metrics_file}{quality per barcode file for the barcodes in the matrix if using the \code{cellranger} or \code{filter} options.}

\item{lower}{the lower threshold for the data if using the \code{emptydrops} function for cell calling.}

\item{min_uniq_frags}{The minimum number of required unique fragments required for a cell (used for \code{filter} cell calling)}

\item{max_uniq_frags}{The maximum number of required unique fragments required for a cell (used for \code{filter} cell calling)}

\item{min_frac_peak}{The minimum proportion of fragments in a cell to overlap with a peak (used for \code{filter} cell calling)}

\item{min_frac_tss}{The minimum proportion of fragments in a cell to overlap with a tss (used for \code{filter} cell calling)}

\item{min_frac_enhancer}{The minimum proportion of fragments in a cell to overlap with a enhancer sequence (used for \code{filter} cell calling)}

\item{min_frac_promoter}{The minimum proportion of fragments in a cell to overlap with a promoter sequence (used for \code{filter} cell calling)}

\item{max_frac_mito}{The maximum proportion of fragments in a cell that are mitochondrial (used for \code{filter} cell calling)}
}
\description{
the methods to call true cells are of various ways.
implement (i.e. \code{filtering} from \code{scATAC-Pro} as default
}
\examples{
\dontrun{
sc_atac_cell_calling <- function(mat,
 cell_calling,
 output_folder,
 genome_size    = NULL,
 cell_qc_metrics_file = NULL,
 lower          = NULL)
}


}
