% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{plot_QC_pairs}
\alias{plot_QC_pairs}
\title{Plot GGAlly pairs plot of QC statistics from \code{SingleCellExperiment}
object}
\usage{
plot_QC_pairs(sce, sel_col = NULL)
}
\arguments{
\item{sce}{a \code{SingleCellExperiment} object}

\item{sel_col}{a vector of column names which indicate the columns to use for
plot. By default it will be the statistics generated by
`calculate_QC_metrics()`}
}
\value{
a ggplot2 object
}
\description{
Plot GGAlly pairs plot of QC statistics from \code{SingleCellExperiment}
object
}
\examples{
data("sc_sample_data")
data("sc_sample_qc")
sce = SingleCellExperiment(assays = list(counts = as.matrix(sc_sample_data)))
organism(sce) = "mmusculus_gene_ensembl"
gene_id_type(sce) = "ensembl_gene_id"
QC_metrics(sce) = sc_sample_qc
demultiplex_info(sce) = cell_barcode_matching
UMI_dup_info(sce) = UMI_duplication
sce = detect_outlier(sce)

plot_QC_pairs(sce)

}
