% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_benchmark.R
\name{plot_rna_velocity}
\alias{plot_rna_velocity}
\title{Plot RNA velocity as arrows on tSNE plot}
\usage{
plot_rna_velocity(
  results = .getResultsFromGlobal(),
  velocity = results$velocity,
  perplexity = 70,
  arrow.length = 1,
  save = FALSE,
  randseed = 0,
  ...
)
}
\arguments{
\item{results}{The scMultiSim result object}

\item{velocity}{The velocity matrix, by default using the velocity matrix in the result object}

\item{perplexity}{The perplexity for tSNE}

\item{arrow.length}{The length scaler of the arrow}

\item{save}{Whether to save the plot}

\item{randseed}{The random seed}

\item{...}{Other parameters passed to ggplot}
}
\value{
The plot
}
\description{
Plot RNA velocity as arrows on tSNE plot
}
\examples{
results <- sim_example(ncells = 10, velocity = TRUE)
plot_rna_velocity(results, perplexity = 3)
}
