% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_ensemble.R
\name{process_locus_bmbb}
\alias{process_locus_bmbb}
\title{Fit tree models for one locus}
\usage{
process_locus_bmbb(
  mtmutObj,
  loc,
  dom_allele = NULL,
  return_data = FALSE,
  bb_over_bm = TRUE,
  bb_over_bm_p = 0.05,
  bb_over_bm_adj = "fdr",
  ...
)
}
\arguments{
\item{mtmutObj}{a mtmutObj object.}

\item{loc}{string given the locus name (e.g. "chrM1000").}

\item{dom_allele}{string given the dominant allele (e.g. "A"), if NULL auto detect the dominant allele.}

\item{return_data}{logical whether to return the allele count data, if FALSE, the \code{data} in the return value will be NULL. The default is FALSE.}

\item{bb_over_bm}{logical weather to use binomial mixture model result to define the wildtype cells for training beta binomial model.}

\item{bb_over_bm_p}{numeric the binomial mixutre model p value threshold for selecting the wildtype cells for training beta binomial model.}

\item{bb_over_bm_adj}{string the method for adjusting the binomial mixture p value, default is "fdr".}

\item{...}{other parameters control the model fitting.}
}
\value{
A list of three elements:
\item{data}{data.frame of the allele count data.}
\item{locus}{data.table of the VMR and consistency of fwd rev strand.}
\item{model}{list of the model fitting results.}
}
\description{
This function fit binomial mixture model, beta binomial model and calculate the VMR and consistency of fwd rev strand for one locus.
}
\examples{
## Use the example data
f <- system.file("extdata", "mini_dataset.tsv.gz", package = "scMitoMut")

## Create a temporary h5 file
## In real case, we keep the h5 in project folder for future use
f_h5_tmp <- tempfile(fileext = ".h5")

## Load the data with parse_table function
f_h5 <- parse_table(f, sep = "\t", h5_file = f_h5_tmp)

x <- open_h5_file(f_h5)
res <- process_locus_bmbb(x, loc = "chrM.1000")
res

}
