% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scRUVIII.R
\name{scRUVIII}
\alias{scRUVIII}
\title{scRUVIII: RUVIII algorithm optimised for single cell data}
\usage{
scRUVIII(
  Y = Y,
  M = M,
  ctl = ctl,
  fullalpha = NULL,
  k = k,
  cell_type = NULL,
  batch = NULL,
  return_all_RUV = TRUE,
  BPPARAM = SerialParam(),
  BSPARAM = ExactParam(),
  svd_k = 50
)
}
\arguments{
\item{Y}{The unnormalised SC data. A m by n matrix, where m is the number of observations and n is the number of features.}

\item{M}{The replicate mapping matrix.
The mapping matrix has m rows (one for each observation), and each column represents a set of replicates.
The (i, j)-th entry of the mapping matrix is 1 if the i-th observation is in replicate set j, and 0 otherwise.
See ruv::RUVIII for more details.}

\item{ctl}{An index vector to specify the negative controls.
Either a logical vector of length n or a vector of integers.}

\item{fullalpha}{Not used. Please ignore.}

\item{k}{The number of unwanted factors to remove. This is inherited from the ruvK argument from the scMerge::scMerge function.}

\item{cell_type}{An optional vector indicating the cell type information for each cell
in the batch-combined matrix. If it is \code{NULL},
pseudo-replicate procedure will be run to identify cell type.}

\item{batch}{Batch information inherited from the scMerge::scMerge function.}

\item{return_all_RUV}{Whether to return extra information on the RUV function, inherited from the scMerge::scMerge function}

\item{BPPARAM}{A \code{BiocParallelParam} class object from the \code{BiocParallel} package is used. Default is SerialParam().}

\item{BSPARAM}{A \code{BiocSingularParam} class object from the \code{BiocSingular} package is used. Default is ExactParam().}

\item{svd_k}{If BSPARAM is set to \code{RandomParam} or \code{IrlbaParam} class from \code{BiocSingular} package, then 
\code{svd_k} will be used to used to reduce the computational cost of singular value decomposition. Default to 50.}
}
\value{
A list consists of:
\itemize{
\item{RUV-normalised matrices:} If k has multiple values, then the RUV-normalised matrices using
all the supplied k values will be returned.
\item{optimal_ruvK:} The optimal RUV k value as determined by silhouette coefficient.
}
}
\description{
A function to perform location/scale adjustment to data as the input of
RUVIII which also provides the option to select optimal RUVk according to the
silhouette coefficient
}
\examples{
L = ruvSimulate(m = 200, n = 1000, nc = 100, nCelltypes = 3, nBatch = 2, lambda = 0.1, sce = FALSE)
Y = t(log2(L$Y + 1L)); M = L$M; ctl = L$ctl; batch = L$batch;
res = scRUVIII(Y = Y, M = M, ctl = ctl, k = c(5, 10, 15, 20), batch = batch)
}
\author{
Yingxin Lin, Kevin Wang
}
