% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastRUVIII.R
\name{fastRUVIII}
\alias{fastRUVIII}
\title{A fast version of the ruv::RUVIII algorithm}
\usage{
fastRUVIII(
  Y,
  M,
  ctl,
  k = NULL,
  eta = NULL,
  svd_k = 50,
  include.intercept = TRUE,
  average = FALSE,
  BPPARAM = SerialParam(),
  BSPARAM = ExactParam(),
  fullalpha = NULL,
  return.info = FALSE,
  inputcheck = TRUE
)
}
\arguments{
\item{Y}{The unnormalised scRNA-Seq data matrix. 
A m by n matrix, where m is the number of observations and n is the number of features.}

\item{M}{The replicate mapping matrix.
The mapping matrix has m rows (one for each observation), and each column represents a set of replicates. 
The (i, j)-th entry of the mapping matrix is 1 if the i-th observation is in replicate set j, and 0 otherwise.
See ruv::RUVIII for more details.}

\item{ctl}{An index vector to specify the negative controls. Either a logical vector of length n or a vector of integers.}

\item{k}{The number of unwanted factors to remove. This is inherited from the ruvK argument from the scMerge::scMerge function.}

\item{eta}{Gene-wise (as opposed to sample-wise) covariates. See ruv::RUVIII for details.}

\item{svd_k}{If BSPARAM is set to \code{RandomParam} or \code{IrlbaParam} class from \code{BiocSingular} package, then 
\code{svd_k} will be used to used to reduce the computational cost of singular value decomposition. Default to 50.}

\item{include.intercept}{When eta is specified (not NULL) but does not already include an intercept term, this will automatically include one.
See ruv::RUVIII for details.}

\item{average}{Average replicates after adjustment. See ruv::RUVIII for details.}

\item{BPPARAM}{A \code{BiocParallelParam} class object from the \code{BiocParallel} package is used. Default is SerialParam().}

\item{BSPARAM}{A \code{BiocSingularParam} class object from the \code{BiocSingular} package is used. Default is ExactParam().}

\item{fullalpha}{Not used. Please ignore. See ruv::RUVIII for details.}

\item{return.info}{Additional information relating to the computation of normalised matrix. We recommend setting this to true.}

\item{inputcheck}{We recommend setting this to true.}
}
\value{
A normalised matrix of the same dimensions as the input matrix Y.
}
\description{
Perform a fast version of the ruv::RUVIII algorithm for scRNA-Seq data noise estimation
}
\examples{
L = ruvSimulate(m = 200, n = 500, nc = 400, nCelltypes = 3, nBatch = 2, lambda = 0.1, sce = FALSE)
Y = L$Y; M = L$M; ctl = L$ctl
improved1 = scMerge::fastRUVIII(Y = Y, M = M, ctl = ctl, 
k = 20, BSPARAM = BiocSingular::ExactParam())
improved2 = scMerge::fastRUVIII(Y = Y, M = M, ctl = ctl, 
k = 20, BSPARAM = BiocSingular::RandomParam(), svd_k = 50)
old = ruv::RUVIII(Y = Y, M = M, ctl = ctl, k = 20)
all.equal(improved1, old)
all.equal(improved2, old)
}
\author{
Yingxin Lin, John Ormerod, Kevin Wang
}
