// Generated by rstantools.  Do not edit by hand.

#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_scmet_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_scmet");
    reader.add_event(126, 124, "end", "model_scmet");
    return reader;
}
template <typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
rbf_H(const int& L,
          const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& X,
          const T2__& c, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 19;
        validate_non_negative_index("H", "num_elements(X)", num_elements(X));
        validate_non_negative_index("H", "L", L);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> H(num_elements(X), L);
        stan::math::initialize(H, DUMMY_VAR__);
        stan::math::fill(H, DUMMY_VAR__);
        current_statement_begin__ = 20;
        if (as_bool(logical_gt(L, 1))) {
            {
            current_statement_begin__ = 21;
            validate_non_negative_index("ms", "(L - 1)", (L - 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ms((L - 1));
            stan::math::initialize(ms, DUMMY_VAR__);
            stan::math::fill(ms, DUMMY_VAR__);
            current_statement_begin__ = 22;
            local_scalar_t__ h(DUMMY_VAR__);
            (void) h;  // dummy to suppress unused var warning
            stan::math::initialize(h, DUMMY_VAR__);
            stan::math::fill(h, DUMMY_VAR__);
            current_statement_begin__ = 25;
            for (int l = 1; l <= (L - 1); ++l) {
                current_statement_begin__ = 26;
                stan::model::assign(ms, 
                            stan::model::cons_list(stan::model::index_uni(l), stan::model::nil_index_list()), 
                            ((l * ((max(X) - min(X)) / L)) + min(X)), 
                            "assigning variable ms");
            }
            current_statement_begin__ = 29;
            stan::math::assign(h, ((get_base1(ms, 2, "ms", 1) - get_base1(ms, 1, "ms", 1)) * c));
            current_statement_begin__ = 31;
            for (int l = 1; l <= L; ++l) {
                current_statement_begin__ = 32;
                if (as_bool(logical_eq(l, 1))) {
                    current_statement_begin__ = 33;
                    stan::model::assign(H, 
                                stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(l), stan::model::nil_index_list())), 
                                rep_vector(1.0, num_elements(X)), 
                                "assigning variable H");
                } else {
                    current_statement_begin__ = 35;
                    for (int i = 1; i <= num_elements(X); ++i) {
                        current_statement_begin__ = 36;
                        stan::model::assign(H, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(l), stan::model::nil_index_list())), 
                                    stan::math::exp((-(0.5) * pow(((get_base1(X, i, "X", 1) - get_base1(ms, (l - 1), "ms", 1)) / h), 2))), 
                                    "assigning variable H");
                    }
                }
            }
            }
        } else {
            current_statement_begin__ = 41;
            stan::model::assign(H, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        rep_vector(1.0, num_elements(X)), 
                        "assigning variable H");
        }
        current_statement_begin__ = 43;
        return stan::math::promote_scalar<fun_return_scalar_t__>(H);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct rbf_H_functor__ {
    template <typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const int& L,
          const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& X,
          const T2__& c, std::ostream* pstream__) const {
        return rbf_H(L, X, c, pstream__);
    }
};
template <typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__>::type, Eigen::Dynamic, Eigen::Dynamic>
poly_H(const int& L,
           const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& X, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 47;
        validate_non_negative_index("H", "num_elements(X)", num_elements(X));
        validate_non_negative_index("H", "L", L);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> H(num_elements(X), L);
        stan::math::initialize(H, DUMMY_VAR__);
        stan::math::fill(H, DUMMY_VAR__);
        current_statement_begin__ = 48;
        for (int l = 1; l <= L; ++l) {
            current_statement_begin__ = 49;
            if (as_bool(logical_eq(l, 1))) {
                current_statement_begin__ = 50;
                stan::model::assign(H, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(l), stan::model::nil_index_list())), 
                            rep_vector(1.0, num_elements(X)), 
                            "assigning variable H");
            } else if (as_bool(logical_eq(l, 2))) {
                current_statement_begin__ = 52;
                stan::model::assign(H, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(l), stan::model::nil_index_list())), 
                            X, 
                            "assigning variable H");
            } else {
                current_statement_begin__ = 54;
                for (int i = 1; i <= num_elements(X); ++i) {
                    current_statement_begin__ = 55;
                    stan::model::assign(H, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(l), stan::model::nil_index_list())), 
                                pow(get_base1(X, i, "X", 1), (l - 1)), 
                                "assigning variable H");
                }
            }
        }
        current_statement_begin__ = 59;
        return stan::math::promote_scalar<fun_return_scalar_t__>(H);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct poly_H_functor__ {
    template <typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const int& L,
           const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& X, std::ostream* pstream__) const {
        return poly_H(L, X, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_scmet
  : public stan::model::model_base_crtp<model_scmet> {
private:
        int N;
        int J;
        int N_X;
        int L;
        std::vector<int> n;
        std::vector<int> y;
        std::vector<int> C;
        double rbf_c;
        matrix_d X;
        vector_d m_wmu;
        double s_wmu;
        double s_mu;
        vector_d m_wgamma;
        double s_wgamma;
        double a_sgamma;
        double b_sgamma;
public:
    model_scmet(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_scmet(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_scmet_namespace::model_scmet";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 64;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 0);
            current_statement_begin__ = 65;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            check_greater_or_equal(function__, "J", J, 0);
            current_statement_begin__ = 66;
            context__.validate_dims("data initialization", "N_X", "int", context__.to_vec());
            N_X = int(0);
            vals_i__ = context__.vals_i("N_X");
            pos__ = 0;
            N_X = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_X", N_X, 0);
            current_statement_begin__ = 67;
            context__.validate_dims("data initialization", "L", "int", context__.to_vec());
            L = int(0);
            vals_i__ = context__.vals_i("L");
            pos__ = 0;
            L = vals_i__[pos__++];
            check_greater_or_equal(function__, "L", L, 0);
            current_statement_begin__ = 68;
            validate_non_negative_index("n", "N", N);
            context__.validate_dims("data initialization", "n", "int", context__.to_vec(N));
            n = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            size_t n_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < n_k_0_max__; ++k_0__) {
                n[k_0__] = vals_i__[pos__++];
            }
            size_t n_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < n_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "n[i_0__]", n[i_0__], 0);
            }
            current_statement_begin__ = 69;
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(N));
            y = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < y_k_0_max__; ++k_0__) {
                y[k_0__] = vals_i__[pos__++];
            }
            size_t y_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < y_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "y[i_0__]", y[i_0__], 0);
            }
            current_statement_begin__ = 70;
            validate_non_negative_index("C", "J", J);
            context__.validate_dims("data initialization", "C", "int", context__.to_vec(J));
            C = std::vector<int>(J, int(0));
            vals_i__ = context__.vals_i("C");
            pos__ = 0;
            size_t C_k_0_max__ = J;
            for (size_t k_0__ = 0; k_0__ < C_k_0_max__; ++k_0__) {
                C[k_0__] = vals_i__[pos__++];
            }
            size_t C_i_0_max__ = J;
            for (size_t i_0__ = 0; i_0__ < C_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "C[i_0__]", C[i_0__], 0);
            }
            current_statement_begin__ = 71;
            context__.validate_dims("data initialization", "rbf_c", "double", context__.to_vec());
            rbf_c = double(0);
            vals_r__ = context__.vals_r("rbf_c");
            pos__ = 0;
            rbf_c = vals_r__[pos__++];
            check_greater_or_equal(function__, "rbf_c", rbf_c, 0);
            current_statement_begin__ = 72;
            validate_non_negative_index("X", "J", J);
            validate_non_negative_index("X", "N_X", N_X);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(J,N_X));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(J, N_X);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = N_X;
            size_t X_j_1_max__ = J;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 73;
            validate_non_negative_index("m_wmu", "N_X", N_X);
            context__.validate_dims("data initialization", "m_wmu", "vector_d", context__.to_vec(N_X));
            m_wmu = Eigen::Matrix<double, Eigen::Dynamic, 1>(N_X);
            vals_r__ = context__.vals_r("m_wmu");
            pos__ = 0;
            size_t m_wmu_j_1_max__ = N_X;
            for (size_t j_1__ = 0; j_1__ < m_wmu_j_1_max__; ++j_1__) {
                m_wmu(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 74;
            context__.validate_dims("data initialization", "s_wmu", "double", context__.to_vec());
            s_wmu = double(0);
            vals_r__ = context__.vals_r("s_wmu");
            pos__ = 0;
            s_wmu = vals_r__[pos__++];
            check_greater_or_equal(function__, "s_wmu", s_wmu, 0);
            current_statement_begin__ = 75;
            context__.validate_dims("data initialization", "s_mu", "double", context__.to_vec());
            s_mu = double(0);
            vals_r__ = context__.vals_r("s_mu");
            pos__ = 0;
            s_mu = vals_r__[pos__++];
            check_greater_or_equal(function__, "s_mu", s_mu, 0);
            current_statement_begin__ = 76;
            validate_non_negative_index("m_wgamma", "L", L);
            context__.validate_dims("data initialization", "m_wgamma", "vector_d", context__.to_vec(L));
            m_wgamma = Eigen::Matrix<double, Eigen::Dynamic, 1>(L);
            vals_r__ = context__.vals_r("m_wgamma");
            pos__ = 0;
            size_t m_wgamma_j_1_max__ = L;
            for (size_t j_1__ = 0; j_1__ < m_wgamma_j_1_max__; ++j_1__) {
                m_wgamma(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 77;
            context__.validate_dims("data initialization", "s_wgamma", "double", context__.to_vec());
            s_wgamma = double(0);
            vals_r__ = context__.vals_r("s_wgamma");
            pos__ = 0;
            s_wgamma = vals_r__[pos__++];
            check_greater_or_equal(function__, "s_wgamma", s_wgamma, 0);
            current_statement_begin__ = 78;
            context__.validate_dims("data initialization", "a_sgamma", "double", context__.to_vec());
            a_sgamma = double(0);
            vals_r__ = context__.vals_r("a_sgamma");
            pos__ = 0;
            a_sgamma = vals_r__[pos__++];
            check_greater_or_equal(function__, "a_sgamma", a_sgamma, 0);
            current_statement_begin__ = 79;
            context__.validate_dims("data initialization", "b_sgamma", "double", context__.to_vec());
            b_sgamma = double(0);
            vals_r__ = context__.vals_r("b_sgamma");
            pos__ = 0;
            b_sgamma = vals_r__[pos__++];
            check_greater_or_equal(function__, "b_sgamma", b_sgamma, 0);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 85;
            validate_non_negative_index("w_mu", "N_X", N_X);
            num_params_r__ += N_X;
            current_statement_begin__ = 86;
            validate_non_negative_index("w_gamma", "L", L);
            num_params_r__ += L;
            current_statement_begin__ = 87;
            validate_non_negative_index("logit_mu", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 88;
            validate_non_negative_index("logit_gamma", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 89;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_scmet() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 85;
        if (!(context__.contains_r("w_mu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable w_mu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("w_mu");
        pos__ = 0U;
        validate_non_negative_index("w_mu", "N_X", N_X);
        context__.validate_dims("parameter initialization", "w_mu", "vector_d", context__.to_vec(N_X));
        Eigen::Matrix<double, Eigen::Dynamic, 1> w_mu(N_X);
        size_t w_mu_j_1_max__ = N_X;
        for (size_t j_1__ = 0; j_1__ < w_mu_j_1_max__; ++j_1__) {
            w_mu(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(10), 10, w_mu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable w_mu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 86;
        if (!(context__.contains_r("w_gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable w_gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("w_gamma");
        pos__ = 0U;
        validate_non_negative_index("w_gamma", "L", L);
        context__.validate_dims("parameter initialization", "w_gamma", "vector_d", context__.to_vec(L));
        Eigen::Matrix<double, Eigen::Dynamic, 1> w_gamma(L);
        size_t w_gamma_j_1_max__ = L;
        for (size_t j_1__ = 0; j_1__ < w_gamma_j_1_max__; ++j_1__) {
            w_gamma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(10), 10, w_gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable w_gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 87;
        if (!(context__.contains_r("logit_mu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable logit_mu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("logit_mu");
        pos__ = 0U;
        validate_non_negative_index("logit_mu", "J", J);
        context__.validate_dims("parameter initialization", "logit_mu", "vector_d", context__.to_vec(J));
        Eigen::Matrix<double, Eigen::Dynamic, 1> logit_mu(J);
        size_t logit_mu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < logit_mu_j_1_max__; ++j_1__) {
            logit_mu(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(20), 20, logit_mu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable logit_mu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 88;
        if (!(context__.contains_r("logit_gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable logit_gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("logit_gamma");
        pos__ = 0U;
        validate_non_negative_index("logit_gamma", "J", J);
        context__.validate_dims("parameter initialization", "logit_gamma", "vector_d", context__.to_vec(J));
        Eigen::Matrix<double, Eigen::Dynamic, 1> logit_gamma(J);
        size_t logit_gamma_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < logit_gamma_j_1_max__; ++j_1__) {
            logit_gamma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(20), 20, logit_gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable logit_gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 89;
        if (!(context__.contains_r("s_gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable s_gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("s_gamma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "s_gamma", "double", context__.to_vec());
        double s_gamma(0);
        s_gamma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, s_gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable s_gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 85;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> w_mu;
            (void) w_mu;  // dummy to suppress unused var warning
            if (jacobian__)
                w_mu = in__.vector_lub_constrain(-(10), 10, N_X, lp__);
            else
                w_mu = in__.vector_lub_constrain(-(10), 10, N_X);
            current_statement_begin__ = 86;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> w_gamma;
            (void) w_gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                w_gamma = in__.vector_lub_constrain(-(10), 10, L, lp__);
            else
                w_gamma = in__.vector_lub_constrain(-(10), 10, L);
            current_statement_begin__ = 87;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> logit_mu;
            (void) logit_mu;  // dummy to suppress unused var warning
            if (jacobian__)
                logit_mu = in__.vector_lub_constrain(-(20), 20, J, lp__);
            else
                logit_mu = in__.vector_lub_constrain(-(20), 20, J);
            current_statement_begin__ = 88;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> logit_gamma;
            (void) logit_gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                logit_gamma = in__.vector_lub_constrain(-(20), 20, J, lp__);
            else
                logit_gamma = in__.vector_lub_constrain(-(20), 20, J);
            current_statement_begin__ = 89;
            local_scalar_t__ s_gamma;
            (void) s_gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                s_gamma = in__.scalar_lb_constrain(0, lp__);
            else
                s_gamma = in__.scalar_lb_constrain(0);
            // transformed parameters
            current_statement_begin__ = 94;
            validate_non_negative_index("mu", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(J);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            stan::math::assign(mu,inv_logit(logit_mu));
            current_statement_begin__ = 95;
            validate_non_negative_index("gamma", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma(J);
            stan::math::initialize(gamma, DUMMY_VAR__);
            stan::math::fill(gamma, DUMMY_VAR__);
            stan::math::assign(gamma,inv_logit(logit_gamma));
            current_statement_begin__ = 96;
            validate_non_negative_index("f_mu", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> f_mu(J);
            stan::math::initialize(f_mu, DUMMY_VAR__);
            stan::math::fill(f_mu, DUMMY_VAR__);
            stan::math::assign(f_mu,multiply(X, w_mu));
            current_statement_begin__ = 97;
            validate_non_negative_index("f_gamma", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> f_gamma(J);
            stan::math::initialize(f_gamma, DUMMY_VAR__);
            stan::math::fill(f_gamma, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 99;
            stan::math::assign(f_gamma, multiply(rbf_H(L, mu, rbf_c, pstream__), w_gamma));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 94;
            size_t mu_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "mu", mu, 1e-15);
            check_less_or_equal(function__, "mu", mu, (1 - 1e-15));
            current_statement_begin__ = 95;
            size_t gamma_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(gamma(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: gamma" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable gamma: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "gamma", gamma, 1e-15);
            check_less_or_equal(function__, "gamma", gamma, (1 - 1e-15));
            current_statement_begin__ = 96;
            size_t f_mu_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < f_mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(f_mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: f_mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable f_mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "f_mu", f_mu, -(40));
            check_less_or_equal(function__, "f_mu", f_mu, 40);
            current_statement_begin__ = 97;
            size_t f_gamma_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < f_gamma_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(f_gamma(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: f_gamma" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable f_gamma: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "f_gamma", f_gamma, -(40));
            check_less_or_equal(function__, "f_gamma", f_gamma, 40);
            // model body
            {
            current_statement_begin__ = 104;
            int pos(0);
            (void) pos;  // dummy to suppress unused var warning
            stan::math::fill(pos, std::numeric_limits<int>::min());
            current_statement_begin__ = 105;
            stan::math::assign(pos, 1);
            current_statement_begin__ = 106;
            lp_accum__.add(inv_gamma_log<propto__>(s_gamma, a_sgamma, b_sgamma));
            current_statement_begin__ = 107;
            lp_accum__.add(normal_log<propto__>(w_mu, m_wmu, s_wmu));
            current_statement_begin__ = 108;
            lp_accum__.add(normal_log<propto__>(w_gamma, m_wgamma, s_wgamma));
            current_statement_begin__ = 109;
            lp_accum__.add(normal_log<propto__>(logit_mu, f_mu, s_mu));
            current_statement_begin__ = 110;
            lp_accum__.add(normal_log<propto__>(logit_gamma, f_gamma, s_gamma));
            current_statement_begin__ = 112;
            for (int j = 1; j <= J; ++j) {
                current_statement_begin__ = 114;
                lp_accum__.add(beta_binomial_log<propto__>(segment(y, pos, get_base1(C, j, "C", 1)), segment(n, pos, get_base1(C, j, "C", 1)), ((get_base1(mu, j, "mu", 1) / get_base1(gamma, j, "gamma", 1)) - get_base1(mu, j, "mu", 1)), ((((1 - get_base1(mu, j, "mu", 1)) / get_base1(gamma, j, "gamma", 1)) + get_base1(mu, j, "mu", 1)) - 1)));
                current_statement_begin__ = 117;
                stan::math::assign(pos, (pos + get_base1(C, j, "C", 1)));
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("w_mu");
        names__.push_back("w_gamma");
        names__.push_back("logit_mu");
        names__.push_back("logit_gamma");
        names__.push_back("s_gamma");
        names__.push_back("mu");
        names__.push_back("gamma");
        names__.push_back("f_mu");
        names__.push_back("f_gamma");
        names__.push_back("epsilon");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(N_X);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(L);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_scmet_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> w_mu = in__.vector_lub_constrain(-(10), 10, N_X);
        size_t w_mu_j_1_max__ = N_X;
        for (size_t j_1__ = 0; j_1__ < w_mu_j_1_max__; ++j_1__) {
            vars__.push_back(w_mu(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> w_gamma = in__.vector_lub_constrain(-(10), 10, L);
        size_t w_gamma_j_1_max__ = L;
        for (size_t j_1__ = 0; j_1__ < w_gamma_j_1_max__; ++j_1__) {
            vars__.push_back(w_gamma(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> logit_mu = in__.vector_lub_constrain(-(20), 20, J);
        size_t logit_mu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < logit_mu_j_1_max__; ++j_1__) {
            vars__.push_back(logit_mu(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> logit_gamma = in__.vector_lub_constrain(-(20), 20, J);
        size_t logit_gamma_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < logit_gamma_j_1_max__; ++j_1__) {
            vars__.push_back(logit_gamma(j_1__));
        }
        double s_gamma = in__.scalar_lb_constrain(0);
        vars__.push_back(s_gamma);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 94;
            validate_non_negative_index("mu", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu(J);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            stan::math::assign(mu,inv_logit(logit_mu));
            current_statement_begin__ = 95;
            validate_non_negative_index("gamma", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, 1> gamma(J);
            stan::math::initialize(gamma, DUMMY_VAR__);
            stan::math::fill(gamma, DUMMY_VAR__);
            stan::math::assign(gamma,inv_logit(logit_gamma));
            current_statement_begin__ = 96;
            validate_non_negative_index("f_mu", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, 1> f_mu(J);
            stan::math::initialize(f_mu, DUMMY_VAR__);
            stan::math::fill(f_mu, DUMMY_VAR__);
            stan::math::assign(f_mu,multiply(X, w_mu));
            current_statement_begin__ = 97;
            validate_non_negative_index("f_gamma", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, 1> f_gamma(J);
            stan::math::initialize(f_gamma, DUMMY_VAR__);
            stan::math::fill(f_gamma, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 99;
            stan::math::assign(f_gamma, multiply(rbf_H(L, mu, rbf_c, pstream__), w_gamma));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 94;
            check_greater_or_equal(function__, "mu", mu, 1e-15);
            check_less_or_equal(function__, "mu", mu, (1 - 1e-15));
            current_statement_begin__ = 95;
            check_greater_or_equal(function__, "gamma", gamma, 1e-15);
            check_less_or_equal(function__, "gamma", gamma, (1 - 1e-15));
            current_statement_begin__ = 96;
            check_greater_or_equal(function__, "f_mu", f_mu, -(40));
            check_less_or_equal(function__, "f_mu", f_mu, 40);
            current_statement_begin__ = 97;
            check_greater_or_equal(function__, "f_gamma", f_gamma, -(40));
            check_less_or_equal(function__, "f_gamma", f_gamma, 40);
            // write transformed parameters
            if (include_tparams__) {
                size_t mu_j_1_max__ = J;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    vars__.push_back(mu(j_1__));
                }
                size_t gamma_j_1_max__ = J;
                for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
                    vars__.push_back(gamma(j_1__));
                }
                size_t f_mu_j_1_max__ = J;
                for (size_t j_1__ = 0; j_1__ < f_mu_j_1_max__; ++j_1__) {
                    vars__.push_back(f_mu(j_1__));
                }
                size_t f_gamma_j_1_max__ = J;
                for (size_t j_1__ = 0; j_1__ < f_gamma_j_1_max__; ++j_1__) {
                    vars__.push_back(f_gamma(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 123;
            validate_non_negative_index("epsilon", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, 1> epsilon(J);
            stan::math::initialize(epsilon, DUMMY_VAR__);
            stan::math::fill(epsilon, DUMMY_VAR__);
            stan::math::assign(epsilon,subtract(logit_gamma, f_gamma));
            // validate, write generated quantities
            current_statement_begin__ = 123;
            size_t epsilon_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                vars__.push_back(epsilon(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_scmet";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t w_mu_j_1_max__ = N_X;
        for (size_t j_1__ = 0; j_1__ < w_mu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w_mu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t w_gamma_j_1_max__ = L;
        for (size_t j_1__ = 0; j_1__ < w_gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w_gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t logit_mu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < logit_mu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "logit_mu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t logit_gamma_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < logit_gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "logit_gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "s_gamma";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t mu_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t gamma_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t f_mu_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < f_mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "f_mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t f_gamma_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < f_gamma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "f_gamma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t epsilon_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "epsilon" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t w_mu_j_1_max__ = N_X;
        for (size_t j_1__ = 0; j_1__ < w_mu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w_mu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t w_gamma_j_1_max__ = L;
        for (size_t j_1__ = 0; j_1__ < w_gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w_gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t logit_mu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < logit_mu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "logit_mu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t logit_gamma_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < logit_gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "logit_gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "s_gamma";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t mu_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t gamma_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t f_mu_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < f_mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "f_mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t f_gamma_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < f_gamma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "f_gamma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t epsilon_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "epsilon" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_scmet_namespace::model_scmet stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
