% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{scmet_to_sce}
\alias{scmet_to_sce}
\title{Convert from scmet to SingleCellExperiment object.}
\usage{
scmet_to_sce(Y, X = NULL)
}
\arguments{
\item{Y}{Methylation data in data.table format.}

\item{X}{(Optional) Matrix of covariates.}
}
\value{
An SCE object with the structure described above.
}
\description{
Helper function that converts an scmet to SCE object. The
structure of the SCE object to store single cell methylation data is the
following. We create two assays, \code{met} storing methylated CpGs and \code{total}
storing total number of CpGs. Rows correspond to features and columns to
cells, similar to scRNA-seq convention. The \code{rownames} and \code{colnames} slots
should store the feature and cell names, respectively. Covariates \code{X}
that might explain variability in mean (methylation) should be stored
in \verb{metadata(rowData(sce)$X}.
}
\examples{
# Extract
sce <- scmet_to_sce(Y = scmet_dt$Y, X = scmet_dt$X)

}
\seealso{
\code{\link{scmet}}, \code{\link{scmet_differential}},
\code{\link{scmet_hvf_lvf}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
