% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_plots.R
\name{scmet_plot_ma}
\alias{scmet_plot_ma}
\title{MA plot for differential analysis}
\usage{
scmet_plot_ma(
  diff_obj,
  task = "diff_epsilon",
  x = "mu",
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  nfeatures = NULL
)
}
\arguments{
\item{diff_obj}{The differential scMET object after calling the
\code{\link{scmet_differential}} function.}

\item{task}{The differential test to plot. For differential mean methylation:
\code{diff_mu} that plots the LOR(mu_A, mu_B) on y-axis. For differential
variability: either (1) \code{diff_epsilon} that plots the change (epsilon_A -
epsilon_B), or (2) \code{diff_gamma} that plots the LOR(gamma_A, gamma_B) on
y-axis.}

\item{x}{The average parameter across the two populations to plot on the
x-axis. Can be either \code{mu}, \code{epsilon} or \code{gamma}. When \code{task = epsilon}, x
can be either \code{mu} or \code{epsilon}. When \code{task = gamma}, x can be either \code{mu}
or \code{gamma}. When \code{task = mu}, x can be only \code{mu}.}

\item{xlab}{Optional x-axis label.}

\item{ylab}{Optional y-axis label.}

\item{title}{Optional title, default NULL.}

\item{nfeatures}{Optional parameter, denoting a subset of number of features
to plot (only for non-differential features). Mostly to reduce
over-plotting.}
}
\value{
A ggplot2 object.
}
\description{
Function showing MA plots for differential analysis. The y-axis
shows difference between measurements across two groups and the x-axis
shows the average measurements across the two groups.
}
\examples{
\dontrun{
# Fit scMET for each group
fit_A <- scmet(Y = scmet_diff_dt$scmet_dt_A$Y,
X = scmet_diff_dt$scmet_dt_A$X, L = 4, iter = 100, seed = 12)
fit_B <- scmet(Y = scmet_diff_dt$scmet_dt_B$Y,
X = scmet_diff_dt$scmet_dt_B$X, L = 4, iter = 100, seed = 12)

# Run differential test
diff_obj <- scmet_differential(obj_A = fit_A, obj_B = fit_B)
# Create volcano plot
scmet_plot_ma(diff_obj, task = "diff_epsilon")
}

}
\seealso{
\code{\link{scmet}}, \code{\link{scmet_differential}},
\code{\link{scmet_hvf_lvf}}, \code{\link{scmet_plot_mean_var}},
\code{\link{scmet_plot_vf_tail_prob}},
\code{\link{scmet_plot_efdr_efnr_grid}}, \code{\link{scmet_plot_volcano}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
