% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testSlope.R
\name{testSlope}
\alias{testSlope}
\title{Test whether a gene is dynamic over a pseudotime interval.}
\usage{
testSlope(test.dyn.res = NULL, p.adj.method = "fdr", fdr.cutoff = 0.01)
}
\arguments{
\item{test.dyn.res}{The list returned by \code{\link{testDynamic}} - no 
extra processing required. Defaults to NULL.}

\item{p.adj.method}{The method used to adjust the \emph{p}-values for each 
coefficient. Defaults to "fdr".}

\item{fdr.cutoff}{The FDR threshold for determining statistical 
significance. Defaults to 0.01.}
}
\value{
A dataframe containing the genes, breakpoints, and coefficient 
\emph{p}-values from each model.
}
\description{
This function tests whether each gene's estimated \eqn{\beta} 
for pseudotime differs significantly from 0 over each empirically estimated 
sets of knots / pseudotime intervals using a Wald test.
}
\examples{
data(scLANE_models)
slope_test_res <- testSlope(scLANE_models)
}
\seealso{
\code{\link{testDynamic}}

\code{\link[stats]{p.adjust}}
}
\author{
Jack R. Leary
}
