% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseCandidateGenes.R
\name{chooseCandidateGenes}
\alias{chooseCandidateGenes}
\title{Choose candidate genes for trajectory DE analysis.}
\usage{
chooseCandidateGenes(
  obj = NULL,
  group.by.subject = TRUE,
  id.vec = NULL,
  n.desired.genes = 2000L
)
}
\arguments{
\item{obj}{An object of class
\code{\link[SingleCellExperiment]{SingleCellExperiment}},
\code{\link[Seurat]{Seurat}}, or \code{cell_data_set} (from \code{monocle3}), or a gene-by-cell
matrix (sparse or dense). Defaults to NULL.}

\item{group.by.subject}{Boolean specifying whether or not the summary
statistics should be computed per-subject and then mean-aggregated.
Defaults to TRUE.}

\item{id.vec}{A vector of subject IDs. Defaults to NULL.}

\item{n.desired.genes}{An integer specifying the number of candidate
genes to return. Defaults to 2000.}
}
\value{
A vector of candidate gene names.
}
\description{
This function identifies good gene candidates for trajectory
differential expression modeling by ranking genes based on their mean
expression, SD of expression, and sparsity across cells.
}
\examples{
data(sim_counts)
candidate_genes <- chooseCandidateGenes(sim_counts,
                            id.vec = sim_counts$subject)
}
\author{
Jack R. Leary
}
