% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScHiCcompare.R
\name{scHiCcompare}
\alias{scHiCcompare}
\title{ScHiCcompare: Differential Analysis of Single-Cell Hi-C Data}
\usage{
scHiCcompare(
  file.path.1,
  file.path.2,
  select.chromosome,
  imputation = "RF",
  normalization = "LOESS",
  differential.detect = "MD.cluster",
  main.Distances = seq(1e+07),
  pool.style = "progressive",
  n.imputation = 5,
  maxit = 1,
  outlier.rm = TRUE,
  missPerc.threshold = 95,
  A.min = NULL,
  fprControl.logfc = 0.8,
  alpha = 0.05,
  Plot = TRUE,
  Plot.normalize = FALSE,
  save.output.path = NULL,
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{file.path.1}{Required character string specifying the directory
containing scHi-C data for the first condition (first cell-type group).
The folder should contain '.txt' scHi-C files in modified sparse upper
triangular format with 5 columns (chr1, start1, chr2, start2, IF).}

\item{file.path.2}{Required character string specifying the directory
containing Hi-C data for the second condition (second cell-type group).
The folder should contain '.txt' scHi-C files in modified sparse upper
triangular format with 5 columns (chr1, start1, chr2, start2, IF).}

\item{select.chromosome}{Required integer or character indicating the
chromosome to be analyzed (e.g., 'chr1' or 'chr10').}

\item{imputation}{Character string 'RF' or NULL indicating the
imputation method. Default is 'RF' for Random Forest imputation.}

\item{normalization}{Character string 'LOESS' or NULL indicating the
normalization method. Default is 'LOESS'.}

\item{differential.detect}{Character string 'MD.cluster' indicating the
differential detection method. The default is 'MD.cluster'.}

\item{main.Distances}{Numeric vector indicating the range of interacting
genomic distances (in base pairs) between two regions (e.g., loci or bins)
to focus on (e.g., 1:100000, Inf, etc). The `main.Distance` vector needs to
be proportional to the data's resolution (e.g., for 10kb - 1:10000,
1:50000, 1:100000, Inf, etc). Selecting a large distance range at higher
resolution (e.g., below 200kb) can make the function take longer to run due
to extreme sparsity. The default is 1:10000000.}

\item{pool.style}{Character string specifying the pooling style for
`imputation`. Options are 'none', 'progressive', or 'Fibonacci'.
The default is 'progressive'. If `imputation` is NULL, then `pool.style`
should also be NULL.}

\item{n.imputation}{Integer specifying the number of multiple imputations
for the imputation step, with final imputed values computed as the average
of these multiple imputation values. Increasing the number of imputations
enhances the accuracy of imputed values, though it may increase the
imputation runtime. The default is 5.}

\item{maxit}{Integer specifying the maximum number of iterations for the
internal refinement process within a single `imputation` cycle. Increasing
`maxit` can help stabilize imputed values, though it may increase the
imputation runtime. Default is 1.}

\item{outlier.rm}{Logical. If TRUE, outliers are removed during `imputation`.
The default is TRUE.}

\item{missPerc.threshold}{Numeric value specifying the maximum allowable
percentage of missing data in pool bands outside the `main.Distances` to be
imputed by the `imputation` method. A higher threshold includes more sparse
distances for imputation (e.g., above 95 percent), increasing memory and
runtime, while a lower threshold (e.g., below 50 percent) might reduce the
number of distances imputed. The default is 95.}

\item{A.min}{Numeric value or NULL that sets the A-value quantile cutoff
(e.g., 7, 10, etc) for filtering low average interaction frequencies in
outlier detection during the differential step of `hic_compare()`
from `HiCcompare`. If not provided (NULL), A is auto-detected.}

\item{fprControl.logfc}{Numeric value controlling the false positive rate for
GMM difference clusters (`differential.detect`) (e.g., 0.5, 0.8, 1, 1.5,
etc). Increasing `fprControl.logfc` may reduce the false positive rate but
can also reduce the number of chromatin interaction differences detected.
Default is 0.8, equivalent to a 2-fold change.}

\item{alpha}{Numeric value for the significance level of outlier detection
during the `differential.detect` step by `hic_compare()` from HiCcompare.
The default is 0.05.}

\item{Plot}{Logical value indicates whether to plot the
`differential.detect` results in an MD plot. The default is TRUE.}

\item{Plot.normalize}{Logical value indicates whether to plot the
`normalization` results in an MD plot. The default is FALSE.}

\item{save.output.path}{Character string specifying the directory to save
outputs, including the imputed cells in a modified sparse upper triangular
format, a normalization result table, and a differential analysis result
table. If NULL, no files are saved. The default is NULL.}

\item{BPPARAM}{Parameters for `BiocParallel`, to be passed to the `bpparam()`
function. See `?bpparam()` for more info.}
}
\value{
A custom class object ("checkNumbers") summarize information of
 workflow's steps. At the same time, the object result also contain the
 differential analysis results and intermediate results (imputation,
 pseudo-bulk, normalization). If `save.output.path` is provided, the imputed
 results for both conditions are saved in a sparse format in the given
 directory. Normalization and differential analysis results are also saved
 if `save.output.path` is provided. See the vignette for more details.
}
\description{
This function performs a differential analysis between two single-cell Hi-C
 data groups. It includes the steps of imputation, normalization, and
 detection of differential chromatin interactions (DCIs).
}
\details{
This function implements the ScHiCcompare workflow. It first reads sparse
 Hi-C data from two conditions and, by default, imputes missing interaction
 frequencies using a random forest model (RF) with the choice of
 `pool.style` (either progressive or Fibonacci). With the progressive
 pooling of interaction frequencies, genomic distance ranges increase
 linearly to form subsequent pooled bands, while Fibonacci pooling uses the
 Fibonacci sequence to increase the size of genomic distance ranges.
 Then, the random forest method is applied to individual genomic distance
 ('none' pooling) or pooled bands (when `pool.style` is selected).

Next, pseudo-bulk Hi-C matrices are generated, followed by joint
 normalization using Loess regression (from `HiCcompare`) before detecting
 differential chromatin interactions via a Gaussian Mixture Model (GMM)
 clustering approach. GMM clusters normalized log fold changes in
 interaction frequencies between the two cell types at each genomic distance
 into "difference" and "non-difference" groups. The non-difference group is
 assumed to follow a normal distribution centered around 0.
 The difference cluster comprises points that belong to other distributions.
 If the size of the differences is insufficient to form distinct
 distributions, these differences are identified by the
 `HiCcompare::hic_compare()` function.
}
\examples{
## Load example data for ODC and MG file paths
ODCs_example <- system.file("extdata/ODCs_example", package = "scHiCcompare")
MGs_example <- system.file("extdata/MGs_example", package = "scHiCcompare")

## Run scHiCcompare on example data
result <- scHiCcompare(
  file.path.1 = MGs_example,
  file.path.2 = ODCs_example,
  select.chromosome = "chr20"
)
print(result)

}
