% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scHiC_table.R
\name{scHiC_table}
\alias{scHiC_table}
\title{Create scHiC Interaction Frequency Table}
\usage{
scHiC_table(file.path, cell.type, select.chromosome)
}
\arguments{
\item{file.path}{Character string specifying the directory containing scHi-C
data for condition (a cell-type group). The folder should contain '.txt'
scHi-C files in a modified sparse upper triangular format
(chr1, start1, chr2, start2, IF)}

\item{cell.type}{The cell type name used in the analysis (e.g., 'NSN', 'SN').}

\item{select.chromosome}{The chromosome name to be studied
(e.g., 'chr1' or 'chrX').}
}
\value{
A data frame containing the interaction frequency table with genomic
loci (cell, chromosome, start1, end1) and interaction frequencies (IF) of
each single cell. This table can be used with the \code{Pooling_RF_impute()}
and \code{pseudo_bulkHic()} functions.
}
\description{
This function generates a single-cell Hi-C interaction frequency (IF) table
 for all single cells for a selected chromosome. The resulting table is
 usable for the \code{Pooling_RF_impute()} and \code{pseudo_bulkHic()}
 functions. It reads the input files, extracts the relevant data, and
 outputs a table of interaction frequencies between genomic regions for each
 single cell dataset.
}
\details{
This function processes single-cell Hi-C data in a folder directory, then
 transforms them into a single 'scHiC table' data frame. Each element in the
 list should be in the form of a sparse upper triangular Hi-C matrix with
 five tab-separated columns (chr1, start1, chr2, start2, IF) with no row or
 column names and no quotes around character strings.
}
\examples{
# Load MG data folder example
MGs_example <- system.file("extdata/MGs_example", package = "scHiCcompare")

# Create scHiC table to be used in scHiCcompare
IF_table <- scHiC_table(
  file.path = MGs_example, cell.type = "MG",
  select.chromosome = "chr20"
)

}
