% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PseudoBulk_sparse.R
\name{pseudo_bulkHic}
\alias{pseudo_bulkHic}
\title{Generate Pseudo-bulk Hi-C Data}
\usage{
pseudo_bulkHic(scHiC.table, out = "sparse")
}
\arguments{
\item{scHiC.table}{A data frame containing interaction frequencies across
cells that are created by the \code{scHiC_table()} function.
The first four columns should represent 'cell', 'chr', 'region1', and
'region2',followed by columns representing interaction frequencies ('IF')
for individual cells.}

\item{out}{A character string specifying the output format. It must be either
'sparse' or 'full'. Default is 'sparse'.}
}
\value{
A data frame representing the pseudo-bulk Hi-C data.
 If `out` is 'sparse'; returns a data frame containing a pseudo-bulk matrix
 in the sparse upper triangular Hi-C matrix format with five columns:
  chromosome 1 (chr1), start position 1 (start1), chromosome 2 (chr2),
  start position 2 (start2), and interaction frequency (IF).
  If `out` is 'full';
        returns a full matrix representation of the pseudo-bulk data.
}
\description{
This function generates pseudo-bulk Hi-C data from a single-cell Hi-C
 interaction frequency table. It returns the data in either sparse or full
 matrix format.
}
\examples{
data("scHiC.table_MG_chr22")
data("scHiC.table_ODC_chr22")
pseudo_bulk_MG <- pseudo_bulkHic(scHiC.table_MG_chr22)
pseudo_bulk_ODC <- pseudo_bulkHic(scHiC.table_ODC_chr22)
head(pseudo_bulk_MG)
head(pseudo_bulk_ODC)

}
\references{
Stansfield JC, Cresswell KG, Vladimirov VI  et al (2018).
Hiccompare: an R-package for joint normalization and comparison of HI-C
datasets. BMC Bioinformatics  2018;19:279.
}
