% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_HiCmatrix_heatmap.R
\name{plot_HiCmatrix_heatmap}
\alias{plot_HiCmatrix_heatmap}
\title{Plot Hi-C Interaction Matrix Heatmap}
\usage{
plot_HiCmatrix_heatmap(
  scHiC.sparse,
  zlim = NULL,
  color_low = "white",
  color_high = "red",
  main = NULL,
  figure_name = NULL
)
}
\arguments{
\item{scHiC.sparse}{A modified sparse matrix of Hi-C interaction frequencies
in the format (chr1, start1, chr2, start2, IF).}

\item{zlim}{A numeric vector of length 2 specifying the limits of the color
scale. If `zlim` is not specified, it will include the minimum and maximum
values of the matrix. For example, `zlim = c(0, 10)` limits the color
scale to values between 0 and 10.}

\item{color_low}{A character string specifying the color for the lowest
values. Default is "white". Other options include colors such as
"lightblue", "yellow", or colors defined using hex codes (e.g.,
"#FFFFFF" for white). Users can refer to the R color names documentation
by running `colors()` in R.}

\item{color_high}{A character string specifying the color for the highest
values. Default is "red". Other options include colors such as
"lightblue", "yellow", or colors defined using hex codes (e.g.,
"#FF0000" for red). Users can refer to the R color names documentation
by running `colors()` in R.}

\item{main}{A character string for the main title of the plot. The default
is NULL.}

\item{figure_name}{A character string for additional figure labeling. The
default is NULL.}
}
\value{
A heatmap plot visualizing the Hi-C interaction matrix.
}
\description{
This function generates a heatmap of Hi-C interaction frequencies from
a given sparse matrix, allowing users to visualize either original or
imputed Hi-C data.
}
\examples{
data("ODC.bandnorm_chr20_1")

# Call the function with this sparse matrix to generate the heatmap
plot_HiCmatrix_heatmap(
  scHiC.sparse = ODC.bandnorm_chr20_1,
  zlim = c(0, 7), # Log scale color limits
  color_low = "white", # Color for low values
  color_high = "red", # Color for high values
  main = "Single-Cell Hi-C Heatmap", # Title of the plot
  figure_name = "Example Heatmap" # Subtitle for the plot
)
}
