% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetrize.R
\name{symmetrize}
\alias{symmetrize}
\title{Symmetrize Adjacency Matrices in a SummarizedExperiment}
\usage{
symmetrize(matrix_list, weight_function = "mean", nCores = 1)
}
\arguments{
\item{matrix_list}{A \linkS4class{SummarizedExperiment} object containing
adjacency matrices to symmetrize.}

\item{weight_function}{Character string or function. Method to combine
entries (i, j) and (j, i). Options include \code{"mean"},
\code{"max"}, \code{"min"}, or a user-defined function.}

\item{nCores}{Integer. Number of CPU cores to use for parallel
processing. Defaults to the number of available workers in the current
\pkg{BiocParallel} backend.}
}
\value{
A \linkS4class{SummarizedExperiment} object with symmetrized
adjacency matrices, where for each matrix \eqn{A[i, j] = A[j, i]} for
all \eqn{i \neq j}.
}
\description{
Symmetrizes each adjacency matrix in a \linkS4class{SummarizedExperiment}
by ensuring entries (i, j) and (j, i) are identical, using a specified
combination function.
}
\details{
For each pair of off-diagonal elements (i, j) and (j, i):
\itemize{
\item If one value is zero, the non-zero value is used.
\item If both are non-zero, they are combined using the specified
\code{weight_function}.
}
Diagonal entries are preserved as-is and not modified.

Parallelization is managed via \pkg{BiocParallel} for improved
performance.
}
\examples{
data("toy_counts")


# Infer networks (toy_counts is already a MultiAssayExperiment)
networks <- infer_networks(
    count_matrices_list = toy_counts,
    method = "GENIE3",
    nCores = 1
)
head(networks[[1]])

# Generate adjacency matrices
wadj_se <- generate_adjacency(networks)
swadj_se <- symmetrize(wadj_se, weight_function = "mean")
}
