% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkSet.R
\name{build_network_se}
\alias{build_network_se}
\title{Create a SummarizedExperiment for Network Storage}
\usage{
build_network_se(
  networks,
  networkData = NULL,
  geneData = NULL,
  metadata = list()
)
}
\arguments{
\item{networks}{A list of adjacency matrices (all must have same dimensions)}

\item{networkData}{A DataFrame with metadata for each network}

\item{geneData}{Optional. A DataFrame with gene-level annotations}

\item{metadata}{Optional. List of global metadata}
}
\value{
A SummarizedExperiment object where each assay is a p×p network
}
\description{
Constructs a SummarizedExperiment container for multiple gene regulatory
network adjacency matrices with shared gene space (p×p matrices).
}
\examples{
# Example 1: Building SE from a list of adjacency matrices
data("toy_adj_matrix")

# Create a list of network matrices
net_list <- list(
    network1 = toy_adj_matrix,
    network2 = toy_adj_matrix
)

# Build SummarizedExperiment
network_se <- build_network_se(net_list)
network_se

# Example 2: Using with inferred networks
data("toy_counts")

networks <- infer_networks(
    count_matrices_list = toy_counts,
    method = "GENIE3",
    nCores = 1
)

# generate_adjacency() internally uses build_network_se()
wadj_se <- generate_adjacency(networks)
wadj_se
}
