% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scgps_prediction_summary.R
\name{summary_accuracy}
\alias{summary_accuracy}
\title{get percent accuracy for Lasso model, from \code{n} bootstraps}
\usage{
summary_accuracy(object = NULL)
}
\arguments{
\item{object}{is a list containing the training results from 
the \code{summary_accuracy} summarise \code{n} bootstraps}
}
\value{
a vector of percent accuracy for the selected subpopulation
}
\description{
The training results from \code{training} were written to
}
\examples{
c_selectID<-1
day2 <- day_2_cardio_cell_sample
mixedpop1 <-new_scGPS_object(ExpressionMatrix = day2$dat2_counts, 
    GeneMetadata = day2$dat2geneInfo, CellMetadata = day2$dat2_clusters)
day5 <- day_5_cardio_cell_sample
mixedpop2 <-new_scGPS_object(ExpressionMatrix = day5$dat5_counts, 
    GeneMetadata = day5$dat5geneInfo, CellMetadata = day5$dat5_clusters)
genes <-training_gene_sample
genes <-genes$Merged_unique
LSOLDA_dat <- bootstrap_prediction(nboots = 1,mixedpop1 = mixedpop1, 
    mixedpop2 = mixedpop2, genes=genes, c_selectID, listData =list(),
    cluster_mixedpop1 = colData(mixedpop1)[,1],
    cluster_mixedpop2=colData(mixedpop2)[,1])
summary_accuracy(LSOLDA_dat)
summary_deviance(LSOLDA_dat)
}
\author{
Quan Nguyen, 2017-11-25
}
