% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CORE_clustering.R
\name{plot_optimal_CORE}
\alias{plot_optimal_CORE}
\title{plot one single tree with the optimal clustering result}
\usage{
plot_optimal_CORE(
  original_tree,
  optimal_cluster = NULL,
  shift = -100,
  values = NULL
)
}
\arguments{
\item{original_tree}{a dendrogram object}

\item{optimal_cluster}{a vector of cluster IDs for cells in the dendrogram}

\item{shift}{a numer specifying the gap between the dendrogram and the 
colored}

\item{values}{a vector containing color values of the branches and the
colored bar underneath the tree bar underneath the dendrogram. This
parameter allows better selection of colors for the display.}
}
\value{
a plot with colored braches and bars for the optimal clustering 
result
}
\description{
after an optimal cluster has been identified, users may use this
function to plot the resulting dendrogram with the branch colors represent 
clutering results
}
\examples{
day5 <- day_5_cardio_cell_sample
mixedpop2 <-new_summarized_scGPS_object(ExpressionMatrix = day5$dat5_counts, 
    GeneMetadata = day5$dat5geneInfo, CellMetadata = day5$dat5_clusters)
CORE_cluster <- CORE_clustering(mixedpop2, remove_outlier = c(0))
key_height <- CORE_cluster$optimalClust$KeyStats$Height
optimal_res <- CORE_cluster$optimalClust$OptimalRes
optimal_index = which(key_height == optimal_res)
plot_optimal_CORE(original_tree= CORE_cluster$tree, 
    optimal_cluster = unlist(CORE_cluster$Cluster[optimal_index]),
    shift = -2000)

}
\author{
Quan Nguyen, 2017-11-25
}
