% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CORE_clustering.R
\name{find_stability}
\alias{find_stability}
\title{Calculate stability index}
\usage{
find_stability(list_clusters = NULL, cluster_ref = NULL)
}
\arguments{
\item{list_clusters}{is a object from the iterative clustering runs}

\item{cluster_ref}{is a object from the reference cluster}
}
\value{
a \code{data frame} with stability scores and rand_index results
}
\description{
from clustering results, compare similarity between clusters by
adjusted Randindex
}
\examples{
day5 <- day_5_cardio_cell_sample
mixedpop2 <-new_summarized_scGPS_object(ExpressionMatrix = day5$dat5_counts, 
    GeneMetadata = day5$dat5geneInfo, CellMetadata = day5$dat5_clusters)
cluster_all <-clustering(object=mixedpop2)
stab_df <- find_stability(list_clusters=cluster_all$list_clusters,
                         cluster_ref = cluster_all$cluster_ref)
}
\author{
Quan Nguyen, 2017-11-25
}
