% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CORE_clustering_bagging.R
\name{clustering_bagging}
\alias{clustering_bagging}
\title{HC clustering for a number of resolutions}
\usage{
clustering_bagging(
  object = NULL,
  ngenes = 1500,
  bagging_run = 20,
  subsample_proportion = 0.8,
  windows = seq(from = 0.025, to = 1, by = 0.025),
  remove_outlier = c(0),
  nRounds = 1,
  PCA = FALSE,
  nPCs = 20,
  log_transform = FALSE
)
}
\arguments{
\item{object}{is a \linkS4class{SingleCellExperiment} object from the train
mixed population.}

\item{ngenes}{number of genes used for clustering calculations.}

\item{bagging_run}{an integer specifying the number of bagging runs to be 
computed.}

\item{subsample_proportion}{a numeric specifying the proportion of the tree 
to be chosen in subsampling.}

\item{windows}{a numeric vector specifying the rages of each window.}

\item{remove_outlier}{a vector containing IDs for clusters to be removed
the default vector contains 0, as 0 is the cluster with singletons.}

\item{nRounds}{a integer specifying the number rounds to attempt to remove 
outliers.}

\item{PCA}{logical specifying if PCA is used before calculating distance 
matrix.}

\item{nPCs}{an integer specifying the number of principal components to use.}

\item{log_transform}{boolean whether log transform should be computed}
}
\value{
a list of clustering results containing each bagging run
as well as the clustering of the original tree and the tree itself.
}
\description{
subsamples cells for each bagging run and performs 40 
clustering runs or more depending on windows.
}
\examples{
day5 <- day_5_cardio_cell_sample
mixedpop2 <-new_summarized_scGPS_object(ExpressionMatrix = day5$dat5_counts, 
    GeneMetadata = day5$dat5geneInfo, CellMetadata = day5$dat5_clusters)
test <-clustering_bagging(mixedpop2, remove_outlier = c(0),
    bagging_run = 2, subsample_proportion = .7)
}
\author{
Quan Nguyen, 2017-11-25
}
