% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_run_scfeatures.R
\name{scFeatures}
\alias{scFeatures}
\title{Wrapper function to run all feature types in scFeatures}
\usage{
scFeatures(
  data = NULL,
  sample = NULL,
  celltype = NULL,
  spatialCoords = NULL,
  spotProbability = NULL,
  feature_types = NULL,
  type = "scrna",
  ncores = 1,
  species = "Homo sapiens",
  celltype_genes = NULL,
  aggregated_genes = NULL,
  geneset = NULL
)
}
\arguments{
\item{data}{input data, a matrix of genes by cells}

\item{sample}{a vector of sample information}

\item{celltype}{a vector of cell type information}

\item{spatialCoords}{a list of two vectors containing the x and y coordinates of each cell}

\item{spotProbability}{a matrix of spot probability, each row represents a celltype and each column represents a spot}

\item{feature_types}{vector containing the name of the feature types to generate,
options are "proportion_raw", "proportion_logit" , "proportion_ratio",
"gene_mean_celltype", "gene_prop_celltype", "gene_cor_celltype",
"pathway_gsva" , "pathway_mean", "pathway_prop",
"CCI",
"gene_mean_aggregated", "gene_prop_aggregated", 'gene_cor_aggregated',
"L_stats" , "celltype_interaction" , "morans_I", "nn_correlation".
If no value is provided, all the above feature types will be generated.}

\item{type}{input data type, either "scrna" (stands for single-cell RNA-sequencing data),
"spatial_p" (stands for spatial proteomics data), or "spatial_t" (stands for single cell spatial data )}

\item{ncores}{number of cores , default to 1}

\item{species}{either "Homo sapiens" or "Mus musculus". Defaults to "Homo sapiens" if no value provided}

\item{celltype_genes}{the genes of interest for celltype specific gene expression feature category
If no value is provided, the top variable genes will be used}

\item{aggregated_genes}{the genes of interest for overall aggregated gene expression feature category
If no value is provided, the top variable genes will be used}

\item{geneset}{the geneset of interest for celltype specific pathway feature category
If no value is provided, the 50 hallmark pathways will be used}
}
\value{
a list of dataframes containing the generated feature matrix in the form of sample x features
}
\description{
The scFeatures function generates a variety of features from a Seurat object
containing single cell RNA-sequencing data. By default, all feature types will be generated
and returned in a single list containing multiple data frames.
}
\examples{
utils::data("example_scrnaseq" , package = "scFeatures") 
data <- example_scrnaseq
celltype <- data$celltype
sample <- data$sample
data <- data@assays$RNA@data
scfeatures_result <- scFeatures(data, celltype = celltype, sample = sample, type = "scrna", feature_types = "proportion_raw")

}
