% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_scfeatures.R
\name{run_proportion_logit}
\alias{run_proportion_logit}
\title{Generate cell type proportions, with logit transformation}
\usage{
run_proportion_logit(data, type = "scrna", ncores = 1)
}
\arguments{
\item{data}{A list object containing \code{data} matrix and \code{celltype} and \code{sample} vector.}

\item{type}{The type of dataset, either "scrna", "spatial_t", or "spatial_p".}

\item{ncores}{Number of cores for parallel processing.}
}
\value{
a dataframe of samples x features
The features are in the form of celltype a, celltype b, with the number
representing proportions.
}
\description{
This function calculates the proportions of cells belonging to each cell type,
and applies a logit transformation to the proportions.
The input data must contain \code{sample} and \code{celltype} metadata column.
The function supports scRNA-seq and spatial proteomics.
The function returns a dataframe with samples as rows and cell types as columns.
}
\examples{
utils::data("example_scrnaseq" , package = "scFeatures")
data <- example_scrnaseq[1:50, 1:20]
celltype <- data$celltype
sample <- data$sample
data <- data@assays$RNA@data

alldata <- scFeatures:::formatData(data = data, celltype = celltype, sample = sample )

feature_proportion_logit <- run_proportion_logit(
    alldata,
    type = "scrna", ncores = 1
)

}
