% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{run_association_study_report}
\alias{run_association_study_report}
\title{Create an association study report in HTML format}
\usage{
run_association_study_report(scfeatures_result, output_folder)
}
\arguments{
\item{scfeatures_result}{a named list storing the scFeatures feature output.
Note that the names of the list should be one or multiple of the following:
\code{proportion_raw}, \code{proportion_logit}, \code{proportion_ratio},
\code{gene_mean_celltype}, \code{gene_prop_celltype}, \code{gene_cor_celltype},
\code{pathway_gsva}, \code{pathway_mean}, \code{pathway_prop}, \code{CCI},
\code{gene_mean_aggregated}, \code{gene_cor_aggregated}, and \code{gene_prop_aggregated}.}

\item{output_folder}{the path to the folder where the HTML report
will be saved}
}
\value{
an HTML file, saved to the directory defined in the \code{output_folder}
argument
}
\description{
This function takes the feature matrix generated by
scFeatures as input and creates an HTML report containing the
results of the association study. The report is saved to the specified
output folder.
}
\examples{
\dontrun{
output_folder <- tempdir()
utils::data("scfeatures_result" , package = "scFeatures")
run_association_study_report(scfeatures_result, output_folder )
}
}
