% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_celltype_expression.R
\name{remove_mito_ribo}
\alias{remove_mito_ribo}
\title{Remove mitochondrial and ribosomal genes, and other highly correlated genes}
\usage{
remove_mito_ribo(alldata)
}
\arguments{
\item{alldata}{A list object containing expression data}
}
\value{
The list object with the mitochrondrial and ribosomal genes and other highly
correlated genes removed
}
\description{
This function removes mitochondria and ribosomal genes and genes
highly correlated with these genes, as mitochondria and ribosomal
genes are typically not  interesting to look at.
}
\examples{

utils::data("example_scrnaseq" , package = "scFeatures")
data <- example_scrnaseq
data <- list(data = data@assays$RNA@data)
data <- remove_mito_ribo(data)

}
