% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_num_cell_per_spot}
\alias{get_num_cell_per_spot}
\title{Estimate a relative number of cells per spot for
spatial transcriptomics data}
\usage{
get_num_cell_per_spot(alldata)
}
\arguments{
\item{alldata}{A list object containing spatial transcriptomics}
}
\value{
a vector with the relative number of cells in each spot.
}
\description{
This function takes a list object containing spatial transcriptomics matrix as input
and estimates the relative number of cells per spot in the data.
The number of cells is estimated as the library size scaled to
the range from 1 to 100.
This value stored in the \code{number_cells} attribute.
}
\examples{

utils::data("example_scrnaseq" , package = "scFeatures")
data <- example_scrnaseq@assays$RNA@data
data <- list(data = data)
number_of_cells <- get_num_cell_per_spot(data)


}
