% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_metric}
\alias{plot_metric}
\title{Produce a bar chart of mean (or median) correlation coefficient per bin of feature.}
\usage{
plot_metric(metric_table, selected_metric = c("mean", "median", "score"),
  show_ctrl = TRUE, control_color = "blue", show_threshold = TRUE,
  threshold = 2, threshold_color = "red", line_size = 1,
  annotate_lines = TRUE)
}
\arguments{
\item{metric_table}{A \code{tibble}, usually the output of \code{\link{get_mean_median}}.}

\item{selected_metric}{Which column in \code{metricsTable} to use? Default to \code{mean}.}

\item{show_ctrl}{A boolean. Should a dashed line indicate the estimated background level?}

\item{control_color}{The colour of the background dashed line (default to blue).}

\item{show_threshold}{A boolean. Should a dashed line indicate the estimated threshold level?}

\item{threshold}{How many times the background level should be multiplies do determine a threshold?
Default to 2. The higher the more stringent.}

\item{threshold_color}{The colour of the threshold dashed line (default to blue).}

\item{line_size}{Thickness of the dashed lines.}

\item{annotate_lines}{A boolean. Should the dashed lines be annotated?}
}
\value{
A ggplot2 plot.
}
\description{
Use the output of \code{\link{get_mean_median}} and produce a bar chart of mean
(or median) correlation coefficient per bin of features. Correlations against the
randomised top window are shown as dot-and-whiskers, and are used to estimate a
background level.
}
\examples{
library(magrittr)
scData_hESC \%>\%
    calculate_cvs \%>\%
    define_top_genes(window_size = 100) \%>\%
    bin_scdata(window_size = 1000) \%>\%
    correlate_windows(n_random = 3) \%>\%
    get_mean_median \%>\%
    plot_metric

}
\seealso{
\code{\link{get_mean_median}}
}
