% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{selFeatures}
\alias{selFeatures}
\title{selFeatures}
\usage{
selFeatures(
  sce,
  clusters = NULL,
  nfeatures = 1000,
  propMarkers = 0,
  FDR.max = 0.05
)
}
\arguments{
\item{sce}{A \code{\link[SummarizedExperiment]{SummarizedExperiment-class}},
\code{\link[SingleCellExperiment]{SingleCellExperiment-class}} with a
'counts' assay.}

\item{clusters}{Optional cluster assignments. Should either be a vector of
labels for each cell.}

\item{nfeatures}{The number of features to select.}

\item{propMarkers}{The proportion of features to select from markers (rather
than on the basis of high expression). Ignored if `clusters` isn't given.}

\item{FDR.max}{The maximum marker binom FDR to be included in the selection.
(see \code{\link[scran]{findMarkers}}).}
}
\value{
A vector of feature (i.e. row) names.
}
\description{
Selects features based on cluster-wise expression or marker detection, or a
combination.
}
\examples{
sce <- mockDoubletSCE()
selFeatures(sce, clusters=sce$cluster, nfeatures=5)
}
