% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{directDblClassification}
\alias{directDblClassification}
\title{directClassification}
\usage{
directDblClassification(
  sce,
  dbr = NULL,
  processing = "default",
  iter = 2,
  dims = 20,
  nrounds = 0.25,
  max_depth = 6,
  ...
)
}
\arguments{
\item{sce}{A \code{\link[SummarizedExperiment]{SummarizedExperiment-class}},
\code{\link[SingleCellExperiment]{SingleCellExperiment-class}}, or array of
counts.}

\item{dbr}{The expected doublet rate. By default this is assumed to be 1\%
per thousand cells captured (so 4\% among 4000 thousand cells), which is
appropriate for 10x datasets. Corrections for homeotypic doublets will be
performed on the given rate.}

\item{processing}{Counts (real and artificial) processing. Either
'default' (normal \code{scater}-based normalization and PCA), "rawPCA" (PCA
without normalization), "rawFeatures" (no normalization/dimensional
reduction), "normFeatures" (uses normalized features, without PCA) or a
custom function with (at least) arguments `e` (the matrix of counts) and
`dims` (the desired number of dimensions), returning a named matrix with
cells as rows and components as columns.}

\item{iter}{A positive integer indicating the number of scoring iterations.
At each iteration, real cells that would be called as doublets are excluding
from the training, and new scores are calculated.}

\item{dims}{The number of dimensions used.}

\item{nrounds}{Maximum rounds of boosting. If NULL, will be determined
through cross-validation.}

\item{max_depth}{Maximum depths of each tree.}

\item{...}{Any doublet generation or pre-processing argument passed to
`scDblFinder`.}
}
\value{
A \code{\link[SummarizedExperiment]{SummarizedExperiment-class}}
with the additional `colData` column `directDoubletScore`.
}
\description{
Trains a classifier directly on the expression matrix to distinguish
artificial doublets from real cells.
}
\examples{
sce <- directDblClassification(mockDoubletSCE(), artificialDoublets=1)
boxplot(sce$directDoubletScore~sce$type)
}
