% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{clusterStickiness}
\alias{clusterStickiness}
\title{clusterStickiness}
\usage{
clusterStickiness(
  x,
  type = c("quasibinomial", "nbinom", "binomial", "poisson"),
  inclDiff = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{A table of double statistics, or a SingleCellExperiment on which
\link{scDblFinder} was run using the cluster-based approach.}

\item{type}{The type of test to use (quasibinomial recommended).}

\item{inclDiff}{Logical; whether to include the difficulty in the model. If
NULL, will be used only if there is a significant trend with the enrichment.}

\item{verbose}{Logical; whether to print additional running information.}
}
\value{
A table of test results for each cluster.
}
\description{
Tests for enrichment of doublets created from each cluster (i.e. cluster's
stickiness). Only applicable with >=4 clusters.
Note that when applied to an multisample object, this functions assumes that
the cluster labels match across samples.
}
\examples{
sce <- mockDoubletSCE(rep(200,5), dbl.rate=0.2)
sce <- scDblFinder(sce, clusters=TRUE, artificialDoublets=500)
clusterStickiness(sce)
}
