% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atac.R
\name{amulet}
\alias{amulet}
\title{amulet}
\usage{
amulet(x, ...)
}
\arguments{
\item{x}{The path to a fragments file, or a GRanges object containing the
fragments (with the `name` column containing the barcode, and the `score`
column containing the count).}

\item{...}{Any argument to \code{\link{getFragmentOverlaps}}.}
}
\value{
A data.frame including, for each barcode, the number sites covered by
  more than two reads, the number of reads, and p- and q-values (low values
  indicative of doublets).
}
\description{
ATACseq (Thibodeau, Eroglu, et al., Genome Biology 2021). The rationale is
that cells with unexpectedly many loci covered by more than two reads are 
more likely to be doublets.
}
\details{
When used on normal (or compressed) fragment files, this 
implementation is relatively fast (except for reading in the data) but it 
has a large memory footprint since the overlaps are performed in memory. It 
is therefore recommended to compress the fragment files using bgzip and index
them with Tabix; in this case each chromosome will be read and processed 
separately, leading to a considerably lower memory footprint. See the 
underlying \code{\link{getFragmentOverlaps}} for details.
}
\examples{
# here we use a dummy fragment file for example:
fragfile <- system.file( "extdata", "example_fragments.tsv.gz",
                         package="scDblFinder" )
res <- amulet(fragfile)

}
