% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performUMAP.R
\name{performUMAP}
\alias{performUMAP}
\title{Perform UMAP on an input data-frame or matrix, or \code{SingleCellExperiment} object, using the basic R implementation of UMAP.}
\usage{
performUMAP(
  indata,
  config = NULL,
  assay = "scaled",
  reducedDim = NULL,
  dims = seq_len(20),
  newDimName = NULL,
  useMarkers = NULL,
  verbose = TRUE
)
}
\arguments{
\item{indata}{A data-frame or matrix, or \code{SingleCellExperiment} object. If a
data-frame or matrix, only the derived co-ordinates for the first two
dimensions are returned. If a \code{SingleCellExperiment} object, UMAP is
performed on the assay named by \code{assay}, and the co-ordinates for the
first two dimensions are stored as a reduced dimension named by
\code{reducedDim}.}

\item{config}{UMAP configuration settings}

\item{assay}{Name of the assay slot in \code{indata} from which data will be
taken, assuming \code{indata} is a \code{SingleCellExperiment} object.}

\item{reducedDim}{A dimensional reduction / embedding stored within
\code{indata}, e.g., PCA. If activated, UMAP will be performed on this object in
place of the assay component specified by \code{assay}.}

\item{dims}{If 'reducedDim' is activated, the number of dimensions to use.}

\item{newDimName}{Name for the new dimensional embedding that will be produced.
If nothing is selected for neither this nor \code{reducedDim}, then the new name
will be \code{UMAP}. If nothing is selected for this, but, e.g., \code{PCA} is selected
for \code{reducedDim}, then the new name will be \code{UMAP_PCA}.}

\item{useMarkers}{Before performing UMAP, subset the data for these markers.}

\item{verbose}{Boolean (TRUE / FALSE) to print messages to console or not.}
}
\value{
A \code{SingleCellExperiment} object.
}
\description{
Perform UMAP on an input data-frame or matrix, or \code{SingleCellExperiment} object, using the basic R implementation of UMAP.
}
\details{
Perform UMAP on an input data-frame or matrix, or \code{SingleCellExperiment} object, using the basic R implementation of UMAP.
}
\examples{
# create random data that follows a negative binomial
mat <- jitter(matrix(
  MASS::rnegbin(rexp(1000, rate=.1), theta = 4.5),
  ncol = 20))
colnames(mat) <- paste0('CD', 1:ncol(mat))

performUMAP(mat)

}
\author{
Kevin Blighe <kevin@clinicalbioinformatics.co.uk>
}
