% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scClassify.R
\name{scClassify}
\alias{scClassify}
\title{Train and test scClassify model}
\usage{
scClassify(
  exprsMat_train = NULL,
  cellTypes_train = NULL,
  exprsMat_test = NULL,
  cellTypes_test = NULL,
  tree = "HOPACH",
  algorithm = "WKNN",
  selectFeatures = "limma",
  similarity = "pearson",
  cutoff_method = c("dynamic", "static"),
  weighted_ensemble = FALSE,
  weights = NULL,
  weighted_jointClassification = TRUE,
  cellType_tree = NULL,
  k = 10,
  topN = 50,
  hopach_kmax = 5,
  pSig = 0.01,
  prob_threshold = 0.7,
  cor_threshold_static = 0.5,
  cor_threshold_high = 0.7,
  returnList = TRUE,
  parallel = FALSE,
  BPPARAM = BiocParallel::SerialParam(),
  verbose = FALSE
)
}
\arguments{
\item{exprsMat_train}{A matrix of log-transformed expression matrix of reference dataset}

\item{cellTypes_train}{A vector of cell types of reference dataset}

\item{exprsMat_test}{A list or a matrix indicates the expression matrices of the query datasets}

\item{cellTypes_test}{A list or a vector indicates cell types of the query datasets (Optional).}

\item{tree}{A vector indicates the method to build hierarchical tree, set as "HOPACH" by default.
This should be one of "HOPACH" and "HC" (using hclust).}

\item{algorithm}{A vector indicates the KNN method that are used, set as
"WKNN" by default. Thisshould be one or more of "WKNN", "KNN", "DWKNN".}

\item{selectFeatures}{A vector indicates the gene selection method, set as "limma" by default.
This should be one or more of "limma", "DV", "DD", "chisq", "BI" and "Cepo".}

\item{similarity}{A vector indicates the similarity measure that are used,
set as "pearson" by default. This should be one or more of "pearson",
"spearman", "cosine", "jaccard", kendall", "binomial", "weighted_rank","manhattan"}

\item{cutoff_method}{A vector indicates the method to cutoff the correlation distribution.
Set as "dynamic" by default.}

\item{weighted_ensemble}{A logical input indicates in ensemble learning,
whether the results is combined by a weighted score for each base classifier.}

\item{weights}{A vector indicates the weights for ensemble}

\item{weighted_jointClassification}{A logical input indicates in joint classification
using multiple training datasets,
whether the results is combined by a weighted score for each training model.}

\item{cellType_tree}{A list indicates the cell type tree provided by user.
(By default, it is NULL) (Only for one training data input)}

\item{k}{An integer indicates the number of neighbour}

\item{topN}{An integer indicates the top number of features that are selected}

\item{hopach_kmax}{An integer between 1 and 9 specifying the maximum number of
children at each node in the HOPACH tree.}

\item{pSig}{A numeric indicates the cutoff of pvalue for features}

\item{prob_threshold}{A numeric indicates the probability threshold for KNN/WKNN/DWKNN.}

\item{cor_threshold_static}{A numeric indicates the static correlation threshold.}

\item{cor_threshold_high}{A numeric indicates the highest correlation threshold}

\item{returnList}{A logical input indicates whether the output will be class of list}

\item{parallel}{A logical input indicates whether running in paralllel or not}

\item{BPPARAM}{A \code{BiocParallelParam} class object
from the \code{BiocParallel} package is used. Default is SerialParam().}

\item{verbose}{A logical input indicates whether the intermediate steps will be printed}
}
\value{
A list of the results, including testRes storing the results of the testing information,
and trainRes storing the training model inforamtion.
}
\description{
Train and test scClassify model
}
\examples{

data("scClassify_example")
xin_cellTypes <- scClassify_example$xin_cellTypes
exprsMat_xin_subset <- scClassify_example$exprsMat_xin_subset
wang_cellTypes <- scClassify_example$wang_cellTypes
exprsMat_wang_subset <- scClassify_example$exprsMat_wang_subset

scClassify_res <- scClassify(exprsMat_train = exprsMat_xin_subset,
cellTypes_train = xin_cellTypes,
exprsMat_test = list(wang = exprsMat_wang_subset),
cellTypes_test = list(wang = wang_cellTypes),
tree = "HOPACH",
algorithm = "WKNN",
selectFeatures = c("limma"),
similarity = c("pearson"),
returnList = FALSE,
verbose = FALSE)

}
\author{
Yingxin Lin
}
