#' @title Example data used in scClassify package
#' @description  A list includes expression matrix and cell type of subsets of
#' wang et al., xin et al.
#'
#' @usage data(scClassify_example, package = 'scClassify')
#' @source
#' Wang YJ, Schug J, Won K-J, Liu C, Naji A, Avrahami D, Golson ML &
#' Kaestner KH (2016) Single cell transcriptomics of the human endocrine
#' pancreas. Diabetes: db160405
#'
#' Xin Y, Kim J, Okamoto H, Ni M, Wei Y, Adler C, Murphy AJ, Yancopoulos GD,
#' Lin C & Gromada J (2016) RNA sequencing of single human islet cells reveals
#' type 2 diabetes genes. Cell Metab. 24: 608–615
"scClassify_example"


#' @title Subset of pretrained model of Xin et al.
#' @description  An obejct of scClassifyTrainModel for Xin et al.
#' @usage data(trainClassExample_xin, package = 'scClassify')
#' @source Xin Y, Kim J, Okamoto H, Ni M, Wei Y, Adler C, Murphy AJ, Yancopoulos GD,
#' Lin C & Gromada J (2016) RNA sequencing of single human islet cells reveals
#' type 2 diabetes genes. Cell Metab. 24: 608–615
"trainClassExample_xin"

#' @title Subset of pretrained model of Wang et al.
#' @description  An obejct of scClassifyTrainModel for Wang et al.
#' @usage data(trainClassExample_wang, package = 'scClassify')
#'
#' @source Wang YJ, Schug J, Won K-J, Liu C, Naji A, Avrahami D, Golson ML &
#' Kaestner KH (2016) Single cell transcriptomics of the human endocrine
#' pancreas. Diabetes: db160405
#'
"trainClassExample_wang"
