% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BFA.R
\name{BinaryPCA}
\alias{BinaryPCA}
\title{Performs Binary PCA (as outlined in our paper).
This function take the input of gene expression profile and
perform PCA on gene detection pattern}
\usage{
BinaryPCA(scData, X = NULL, scale. = FALSE, center = TRUE)
}
\arguments{
\item{scData}{can be a raw count matrix,
in which rows are genes and columns are cells;
can be a seurat object; can be a SingleCellExperiment object.}

\item{X}{\eqn{N} by \eqn{C} covariate matrix,e.g batch effect,
in which rows are cells,columns are number of covariates.
If no such covariates available X = NULL}

\item{scale.}{Logical value isndicating whether the variables should be
scaled to have unit variance before the analysis takes place.
In general scaling is not advisable, since we think the variance in the
gene detection space is potentially associated with celltypes
(e.g cell type specific markers)}

\item{center}{Logical value indicating whether the variables
should be shifted to be zero centered}
}
\value{
A list with class "prcomp",containing the following components:

sdev: the standard deviations of the principal components
(i.e., the square roots of the eigenvalues of
the covariance/correlation matrix, though the calculation is
actually done with the singular values of the data matrix).

rotation: the matrix of variable loadings
(i.e., a matrix whose columns contain the eigenvectors).
The function princomp returns this in the element loadings.

x: the rotated data (the centred (and scaled if requested)
data multiplied by the rotation matrix) is returned.
Hence, cov(x) is the diagonal matrix diag(sdev^2).

center, scale. centering and scaling used, or FALSE.
}
\description{
Performs Binary PCA (as outlined in our paper).
This function take the input of gene expression profile and
perform PCA on gene detection pattern
}
\examples{

## Working with Seurat or SingleCellExperiment object

library(Seurat)
library(SingleCellExperiment)

## Input expression profile, 5 genes x 3 cells

GeneExpr = matrix(rpois(15,1),nrow = 5,ncol = 3)
rownames(GeneExpr) = paste0("gene",seq_len(nrow(GeneExpr)))
colnames(GeneExpr) = paste0("cell",seq_len(ncol(GeneExpr)))
celltype = as.factor(sample(c(1,2,3),3,replace = TRUE))

## Create cell level technical batches

batch = sample(c("replicate 1","replicate 2","replicate 2"))
X = matrix(NA,nrow = length(batch),ncol = 1)
X[which(batch =="replicate 1"), ] = 0
X[which(batch =="replicate 2"), ] = 1
rownames(X) = colnames(GeneExpr)

##run BFA with raw count matrix

bpca_model = BinaryPCA(scData = GeneExpr,X = scale(X))

## Create Seurat object for input to BFA

scData = CreateSeuratObject(counts = GeneExpr,project = "sc",min.cells = 0)

## Standardize the covariate matrix should be a default operation

bpca_model = BinaryPCA(scData = scData, X = scale(X))

## Build the SingleCellExperiment object for input to BFA

## Set up SingleCellExperiment class

sce <- SingleCellExperiment(assay = list(counts = GeneExpr))

## Standardize the covariate matrix should be a default operation

bpca_model = BinaryPCA(scData = sce, X = scale(X))

}
\keyword{export}
