% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{p_thres}
\alias{p_thres}
\alias{p_thres<-,scAnnotatR-method}
\title{p_thres}
\usage{
p_thres(classifier)

\S4method{p_thres}{scAnnotatR}(classifier) <- value
}
\arguments{
\item{classifier}{scAnnotatR object. 
The object is returned from the train_classifier function.}

\item{value}{the new threshold}
}
\value{
Predicting probability threshold of object

scAnnotatR object with the new threshold.
}
\description{
Returns the probability threshold for the given classifier.
}
\examples{
data("tirosh_mel80_example")
selected_marker_genes_B = c("CD19", "MS4A1", "CD79A")
set.seed(123)
classifier_b <- train_classifier(train_obj = tirosh_mel80_example,
assay = 'RNA', slot = 'counts', marker_genes = selected_marker_genes_B, 
cell_type = "B cells", tag_slot = 'active.ident')
p_thres(classifier_b)

data("tirosh_mel80_example")
selected_marker_genes_B = c("CD19", "MS4A1", "CD79A")
set.seed(123)
classifier_b <- train_classifier(train_obj = tirosh_mel80_example,
assay = 'RNA', slot = 'counts', marker_genes = selected_marker_genes_B, 
cell_type = "B cells", tag_slot = 'active.ident')
classifier_b_test <- test_classifier(classifier = classifier_b, 
test_obj = tirosh_mel80_example, assay = 'RNA', slot = 'counts', 
tag_slot = 'active.ident')
# assign a new threhold probability for prediction
p_thres(classifier_b) <- 0.4
}
