% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateOffsets.R
\name{calculateOffsets}
\alias{calculateOffsets}
\title{calculating the offsets to perform aberrant expression or splicing
analysis.}
\usage{
calculateOffsets(
  se,
  method,
  aggregation = NULL,
  zeroCountOffsets = 1,
  zeroOffsets = 1,
  mergeGeneASpli = TRUE,
  filterna = TRUE,
  saveall = FALSE
)
}
\arguments{
\item{se}{A `SummarizedExperiment` instance generated with the
SummarizedExperiment function of the SummarizedExperiment package.
In the assay slot, provide the expression counts as an
ordinary `matrix`, `DataFrame`, a `sparseMatrix` or a `DelayedMatrix`.
When offsets are calculated for aberrant splicing (`AS`) or other
proportions (`proportion`), a rowData column is required which is used to
group features over which the sum is taken as offset.}

\item{method}{method used to calculate the offsets. `TMM` uses edgeR's
trimmed mean of M-values, `geommean` uses DESeq2's size factors, `unit` uses
a unit matrix of offsets, `AS` and `proportion` use a rowData column to
aggregate feature counts (e.g. calculating the total bin counts per gene)
for aberrant splicing or other usage analyses.}

\item{aggregation}{column of rowData used to aggregate feature counts. Only
used when `method` is `AS` or `proportion`. If not specified, the `locus`
column is used when available, followed by the `symbol` column.}

\item{zeroCountOffsets}{When using the `AS` or `proportion` method, it is
possible that some offsets are 0. As offsets need to be a strict positive
value, these offsets are changed to a strict positive number (defined by
`zeroOffsets`, with a default of 1). The corresponding count can also be
changed, with a default change to 1. Note that, although it is possible,
it is not recommended to specify `zeroCountOffsets` greater than
`zeroOffsets`.}

\item{zeroOffsets}{When using the `AS` or `proportion` method, it is
possible that some offsets are 0. As offsets need to be a strict positive
value, these offsets are changed to a strict positive number (defined by
`zeroOffsets`, with a default of 1). The corresponding count can also be
changed, with a default change to 1. Note that, although it is possible,
it is not recommended to specify `zeroCountOffsets` greater than
`zeroOffsets`.}

\item{mergeGeneASpli}{logical value. When ASpli is used to obtain feature
counts, one can aggregate feature counts to calculate offsets based on
both gene-level or ASpli-cluster. When `mergeGeneASpli` is TRUE, one uses
gene-level aggregation, except where no annotated gene is available, and
use ASpli-cluster aggregation for these features.}

\item{filterna}{logical value to filter NA locus values in rowData.
These are not necessarily features without annotated gene.}

\item{saveall}{logical value to save all aggregated counts and offsets.
Default is FALSE to save memory. If TRUE, also counts and offsets of
gene-level aggregation and ASpli-cluster aggregation are saved, instead of
only using the final used counts and offsets.}
}
\value{
An updated `SummarizedExperiment` instance, now including an
`offsets` matrix in the assays slot. When `method` is `AS` or `proportion`,
an `realCounts` matrix is available in the assays slot, which correspond to
the original counts, while the `counts` matrix in the assays slot is updated
with to `zeroCountOffsets` when the calculated offset is equal to 0. When
`saveall` is TRUE, also matrices `Locuscounts`, `Locusoffsets`,
`ASplicounts`and `ASplioffsets` are saved in the assays slot, corresponding
to the adapted counts and offsets using the `locus` rowData column, and
using the `symbol` rowData column respectively.
}
\description{
calculateOffsets is used to calculate the offsets for aberrant expression or
splicing analysis. it can use ordinary offsets such as `edgeR` and `DESeq2`
offsets for aberrant expression analysis, or use the total counts aggregated
per gene to perform aberrant splicing analysis. It returns a
`SummarizedExperiment` which  includes an `offsets` matrix in the assays
slot.
}
\examples{

data(saseRExample, package = "saseR")


SEgenes <- calculateOffsets(SEgenes, method = "TMM")
SEbins <- calculateOffsets(SEbins,
                           method = "AS",
                           aggregation = "locus")
SEjunctions <- calculateOffsets(SEjunctions,
                                method = "AS",
                                aggregation = "symbol",
                                mergeGeneASpli = TRUE)

}
